package cn.com.duiba.tool.haoxiangni;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * @author haojiahong
 * @date 2020-12-22
 */
public class SignUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignUtils.class);

    public static String getSign(Map<String, Object> params, String secret) {
        JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(params));
        String[] keys = (String[]) params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder query = new StringBuilder(secret);
        String[] var5 = keys;
        int var6 = keys.length;

        for (int var7 = 0; var7 < var6; ++var7) {
            String key = var5[var7];
            String value = jsonObject.getString(key);
            if (value != null && !"".equals(value) && !value.startsWith("[") && !value.startsWith("{")) {
                query.append(key).append(value);
            }
        }

        try {
            return encryptMD5(query.toString());
        } catch (IOException var10) {
            LOGGER.error("MD5加密异常", var10);
            return null;
        }
    }

    private static String encryptMD5(String data) throws IOException {
        Object var1 = null;

        byte[] bytes;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            bytes = md.digest(data.getBytes("utf-8"));
        } catch (GeneralSecurityException var3) {
            throw new IOException(var3.getMessage());
        }

        return byte2hex(bytes);
    }

    private static String byte2hex(byte[] b) {
        StringBuilder hs = new StringBuilder();

        for (int n = 0; b != null && n < b.length; ++n) {
            String stmp = Integer.toHexString(b[n] & 255);
            if (stmp.length() == 1) {
                hs.append('0');
            }

            hs.append(stmp);
        }

        return hs.toString().toUpperCase();
    }

    public static void main(String[] args) {
//        accessTokenReq();
        infoGetReq();

    }

    public static void accessTokenReq() {
        Map<String, Object> map = new HashMap<>();
        map.put("appKey", "NS10000186035");
        map.put("groupId", 10000186L);
        map.put("nonce", System.currentTimeMillis());
        System.out.println(map.get("nonce"));
        String sign = SignUtils.getSign(map, "D596D045174ACE4AF62315C75C7FEA01");
        System.out.println(sign);
    }

    public static void infoGetReq() {
        Map<String, Object> map = new HashMap<>();
        map.put("appKey", "NS10000186035");
        map.put("groupId", 10000186L);
        map.put("nonce", System.currentTimeMillis());
        map.put("accessToken", "5ae3a76e068e47a3853ce4333917d467");
        map.put("wechatUnionid", "ocUyqwRH1nzg6qCpTBYGrL8NMcIg-1");
        System.out.println(map.get("nonce"));
        String sign = SignUtils.getSign(map, "D596D045174ACE4AF62315C75C7FEA01");
        System.out.println(sign);
    }
}
