package cn.com.duiba.biz.credits;

import cn.com.duiba.domain.ResultGeneralModel;
import cn.com.duiba.domain.TopStarResultVO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.CaiNiaoTool;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @ClassName: TaopiaopiaoApi
 * @Description: 淘票票定制
 * @author: fxr
 * @date: 2018/5/14 下午1:59
 * @version: V1.0.0
 */
@Service
public class TaopiaopiaoApi {


    private static Logger logger = LoggerFactory.getLogger(TaopiaopiaoApi.class);

    /**
     * 兑吧在淘票票的App的appkey
     */
    private static final String TAOPIAOPIAO_APPKEY = "24327934";

    /**
     * 兑吧在淘票票的App的appsecret
     */
    private static final String TAOPIAOPIAO_APPSECRET = "c290043acee4a46c99c47c6382b99f2c";

    /**
     * version
     */
    private static final String TAOPIAOPIAO_VERSION = "2.0";

    /**
     * method
     */
    private static final String TAOPIAOPIAO_METHOD = "taobao.film.star.operate";

    /**
     * sign_method
     */
    private static final String TAOPIAOPIAO_SIGN_METHOD = "hmac";

    /**
     * format
     */
    private static final String TAOPIAOPIAO_FORMAT = "json";

    /**
     * partner_id
     */
    private static final String TAOPIAOPIAO_PARTNER_ID = "DUIBA";

    /**
     * 加积分
     */
    private static final String OPERATE_ADD = "ADD";

    /**
     * 扣积分
     */
    private static final String OPERATE_CONSUME = "CONSUME";

    /**
     * 分隔符
     */
    private static final String DELIMITER = "?";

    /**
     * 构造淘票票扣积分请求.
     *
     * @param request
     * @return
     */
    public CreditsMessage getSubCreditsMessage(CreditsMessage request) {

        try {
            String url = request.getHttpUrl();
            String host = getGateway(url);

            /** 取出原始参数*/
            Map<String, String> originalParams = request.getAuthParams();

            /** 定义参数*/
            Map<String, String> paramsMap = bulidParms(originalParams, OPERATE_CONSUME);

            request.setHttpType(CreditsMessage.HTTP_GET);
            request.setHttpUrl(AssembleTool.assembleUrl(host, paramsMap));
        } catch (Exception e) {
            logger.error("[TaopiaopiaoApi-getSubCreditsMessage]error:{}", e);
        }
        return request;
    }

    /**
     * 构造淘票票加积分请求.
     *
     * @param request
     * @return
     */
    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request) {

        try {

            String url = request.getHttpUrl();
            String host = getGateway(url);
            /** 取出原始参数*/
            Map<String, String> originalParams = request.getAuthParams();

            /** 定义参数*/
            Map<String, String> paramsMap = bulidParms(originalParams, OPERATE_ADD);

            request.setHttpType(CreditsMessageDto.HTTP_GET);
            request.setHttpUrl(AssembleTool.assembleUrl(host, paramsMap));
        } catch (Exception e) {
            logger.error("[TaopiaopiaoApi-getAddCreditsMessage]error:{}", e);
        }
        return request;
    }

    /**
     * 获取接口网关
     *
     * @param url
     * @return java.lang.String
     * @throw
     */
    @Nullable
    private String getGateway(String url) {
        if (StringUtils.isNotBlank(url)) {
            int index = url.indexOf(DELIMITER);
            if (index != -1) {
                return url.substring(0, index);
            }
        }
        return url;
    }

    /**
     * 重新定义参数
     *
     * @param params
     * @param operate
     * @return java.util.Map<java.lang.String,java.lang.String>
     * @throw
     */
    @NotNull
    private Map<String, String> bulidParms(Map<String, String> params, String operate) throws IOException {
        Map<String, String> paramsMap = Maps.newHashMap();

        /** 接口参数*/
        paramsMap.put("timestamp", getTimestamp());
        paramsMap.put("v", TAOPIAOPIAO_VERSION);
        paramsMap.put("app_key", TAOPIAOPIAO_APPKEY);
        paramsMap.put("method", TAOPIAOPIAO_METHOD);
        paramsMap.put("sign_method", TAOPIAOPIAO_SIGN_METHOD);
        paramsMap.put("partner_id", TAOPIAOPIAO_PARTNER_ID);
        paramsMap.put("format", TAOPIAOPIAO_FORMAT);
        paramsMap.put("operate_type", operate);
        paramsMap.put("open_id", params.get("uid"));

        /**
         * 业务参数
         * 接口请求加、减积分时，需要添加固定值的参数channel，淘票票需要据此区分来源
         */
        JSONObject paramJson = new JSONObject();
        paramJson.put("starPoint", params.get("credits"));
        paramJson.put("describe", params.get("description"));
        paramJson.put("bizKey", params.get("orderNum"));
        paramJson.put("channel", "2001");

        paramsMap.put("params", paramJson.toString());
        paramsMap.put("sign", CaiNiaoTool.signTopRequest(paramsMap, TAOPIAOPIAO_APPSECRET));

        return paramsMap;
    }

    private String getTimestamp() {
        DateFormat dateTimeformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateTimeformat.format(new Date());
    }


    /**
     * 转义淘票票街扣积分响应数据
     *
     * @param body
     * @return
     */
    public String parseCreditsRsp(String body) {
        try {
            JSONObject jsonBody = JSON.parseObject(body);
            JSONObject response = jsonBody.getJSONObject("film_star_operate_response");
            ResultGeneralModel resultGeneralModel = JSONObject.parseObject(response.getString("result"), ResultGeneralModel.class);
            TopStarResultVO topStarResultVO = resultGeneralModel.getReturnValue();

            Map<String, String> duibaDoc = new HashMap<>();
            duibaDoc.put("errorMessage", topStarResultVO.getErrorMessage());
            duibaDoc.put("status", topStarResultVO.getStatus());
            duibaDoc.put("bizId", topStarResultVO.getBizId());
            duibaDoc.put("credits", topStarResultVO.getStarPoint());

            return JsonTool.objectToJson(duibaDoc);
        } catch (Exception e) {
            logger.error("[TaopiaopiaoApi-parseCreditsRsp]淘票票请求异常，响应解析出错:{}", e);
            return body;
        }

    }
}
