package cn.com.duiba.biz.credits;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.constant.WatsonsConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.MD5;
import cn.com.duiba.tool.WatsonsSignUtil;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Description: 屈臣氏定制
 * @Author: fxr
 * @Date: 2019/1/3
 */
@Service
public class WatsonsNewApi {

    private static final Logger LOGGER = LoggerFactory.getLogger(WatsonsNewApi.class);

    @Autowired
    private WatsonsConfig watsonsConfig;

    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        try {
            String url = message.getHttpUrl();
            String host = url.substring(0, url.indexOf('?'));
            String params = url.substring(url.indexOf('?') + 1, url.length());
            Map<String, String> urlParams = AssembleTool.getUrlParams(params);

            JSONObject data = new JSONObject();
            data.put("memberId", urlParams.get("uid"));
            data.put("numOfPoint", urlParams.get("credits"));
            data.put("typeCode", "Accrual");
            data.put("productName", "Point Adjustment_for Award points_A");
            data.put("storeId", "1");
            data.put("txnChannel", "System");
            Map<String, Object> newParams = signParam(data);

            return AssembleTool.assembleRequestJson(host, JSON.toJSONString(newParams));
        } catch (Exception e) {
            LOGGER.error("WatsonsApi-getAddCreditsMessage 发生异常，请求参数:message = [{}]", JSON.toJSONString(message), e);
            return null;
        }
    }

    private Map<String, Object> signParam(JSONObject data) throws BizException {
        String appId = watsonsConfig.getDuibaIdentifier2();
        String appSecret = watsonsConfig.getAppSecret();
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000);
        String dataStr = data.toJSONString();
        try {
            String sourceStr = appId + appSecret + timestamp + dataStr;
            String sign = MD5.md5(sourceStr).toUpperCase();
            Map<String, Object> newParams = new HashMap<>();
            newParams.put("appId", appId);
            newParams.put("timestamp", timestamp);
            newParams.put("sign", sign);
            newParams.put("data", data);
            if (!SpringEnvironmentUtils.isProdEnv()) {
                LOGGER.info("watsonsApi获取基础配置:加签数据：{}，基础数据:{}", sourceStr, JSON.toJSONString(newParams));
            }
            return newParams;
        } catch (Exception e) {
            LOGGER.warn("WatsonsApi-signParam 发生异常，请求参数:data = [{}]", data, e);
            throw new BizException("屈臣氏生成签名中断");
        }
    }

    private Map<String, Object> signParam2(JSONObject data) throws BizException {
        String appId = watsonsConfig.getNewAppId();
        String appSecret = watsonsConfig.getNewSecret();
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000);
        String dataStr = data.toJSONString();
        try {
            String sourceStr = appId + appSecret + timestamp + dataStr;
            String sign = MD5.md5(sourceStr).toUpperCase();
            Map<String, Object> newParams = new HashMap<>();
            newParams.put("brandId",watsonsConfig.getBrandId());
            newParams.put("channelId",watsonsConfig.getChannelId());
            newParams.put("appId", appId);
            newParams.put("timestamp", timestamp);
            newParams.put("sign", sign);
            newParams.put("data", data);
            if (!SpringEnvironmentUtils.isProdEnv()) {
                LOGGER.info("watsonsApi获取基础配置:加签数据：{}，基础数据:{}", sourceStr, JSON.toJSONString(newParams));
            }
            return newParams;
        } catch (Exception e) {
            LOGGER.warn("WatsonsApi-signParam 发生异常，请求参数:data = [{}]", data, e);
            throw new BizException("屈臣氏生成签名中断");
        }
    }


    public HttpRequestBase getSubCreditsMessage(SubCreditsMsgWrapper message) {
        /*try {
            String url = message.getHttpUrl();
            String host = url.substring(0, url.indexOf('?'));
            String params = url.substring(url.indexOf('?') + 1, url.length());
            Map<String, String> paramsMap = AssembleTool.getUrlParams(params);
            JSONObject data = new JSONObject();
            data.put("memberNumber", paramsMap.get("uid"));
            data.put("productName", "Point Adjustment_for Duiba Luck Draw Event_A");
            data.put("comments", "for Duiba Luck Draw Event_A");
            data.put("storeId", "1");
            if (watsonsConfig.isUpdate()){
                data.put("posID", "1");
                data.put("transID", "1");
            }else {
                String orderId = paramsMap.get("orderNum");
                data.put("posID", orderId);
                data.put("transID", orderId);
            }
            data.put("businessDate", DateUtils.getSecondStr(new Date()));
            data.put("numOfPoint", paramsMap.get("credits"));
            Map<String, Object> newParams = signParam(data);
            String paramStr = JSON.toJSONString(newParams);
            if (!SpringEnvironmentUtils.isProdEnv()) {
                LOGGER.info("watsonsApi扣积分，请求数据:{}", paramStr);
            }
            return AssembleTool.assembleRequestJson(host, paramStr);
        } catch (Exception e) {
            LOGGER.warn("[watsonsApi- 构建扣积分参数异常]error:{}", e);
            return null;
        }*/
        /*------update begin：author：zhoujunquan@duiba.com.cn，date：2021/4/15 10:28 上午，desc：开发者减积分api修改------*/
        try {
            String url = message.getHttpUrl();
            String host = url.substring(0, url.indexOf('?'));
            String params = url.substring(url.indexOf('?') + 1);
            Map<String, String> paramsMap = AssembleTool.getUrlParams(params);
            Date date = new Date();
            JSONObject data = new JSONObject();
            data.put("memberNumber", paramsMap.get("uid"));
            data.put("productName", "Point Adjustment_for Duiba Luck Draw Event_A");
            data.put("comments", "for Duiba Luck Draw Event_A");
            data.put("storeId", "1");
            data.put("businessDate", DateUtils.getSecondStr(date));
            data.put("numOfPoint", paramsMap.get("credits"));
            data.put("txnChannel", "Web");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            data.put("txnNumber", "WTCCN" + paramsMap.get("uid") + sdf.format(date));
            Map<String, Object> newParams = signParam2(data);
            String paramStr = JSON.toJSONString(newParams);
            if (!SpringEnvironmentUtils.isProdEnv()) {
                LOGGER.info("watsonsApi扣积分，请求数据:{}", paramStr);
            }
            return AssembleTool.assembleRequestJson(host, paramStr);
        } catch (Exception e) {
            LOGGER.warn("[watsonsApi- 构建扣积分参数异常]error:{}", e);
            return null;
        }
        /*------update end：author：zhoujunquan@duiba.com.cn，date：2021/4/15 10:29 上午，desc：开发者减积分api修改------*/
    }

    public String parseCreditsRsp(String body) {

        JSONObject response = JSON.parseObject(body);

        JSONObject json = new JSONObject();
        json.put("errorMessage", response.getString("resultMsg"));
        json.put("bizId", String.valueOf(System.currentTimeMillis()));
        json.put("status", Objects.equals(response.getString("resultCode"), "00000") ? "ok" : "fail");

        return json.toString();
    }

    public HttpRequestBase getVirtualRequestHttp(SupplierRequest request) {
        String url = request.getHttpUrl();


        //post请求,截取出url去除参数的部分,设置为请求url
        String host = url.substring(0, url.indexOf('?'));
        request.setHttpUrl(host);
        //将原get请求的参数转化成map
        String params = url.substring(url.indexOf('?') + 1, url.length());
        //  获取URL中拼接的请求参数
        Map<String, String> urlParams = AssembleTool.getUrlParams(params);

        //  自定义 业务参数
        TreeMap<String, Object> data = new TreeMap<>();
        data.put("user_id", urlParams.get("uid"));
        data.put("keycodes", Collections.singletonList(urlParams.get("params")));
        data.put("trans_id",urlParams.get("orderNum"));
        data.put("channel","兑吧活动");

        TreeMap<String, Object> paramMap = new TreeMap<>();
        paramMap.put("appId", watsonsConfig.getDuibaIdentifier2());
        paramMap.put("certiId", watsonsConfig.getCertiId2());
        paramMap.put("date", DateUtils.getSecondStr(new Date()));

        paramMap.put("data", new JSONObject(data));
        LOGGER.info("watsonsApi虚拟商品，请求数据:{}", JSON.toJSONString(paramMap));

        String sign = WatsonsSignUtil.getSignWithObject(paramMap, watsonsConfig.getToken2());
        paramMap.put("sign", sign);
        request.setHttpUrl(host);
        return AssembleTool.assembleRequestJson(request.getHttpUrl(), JSON.toJSONString(paramMap));
    }

    /**
     * 转义屈臣氏虚拟权益兑换响应.
     *
     * @param body
     * @return
     */
    public String getVirtualResponse(String body) {
        if (StringUtils.isBlank(body)) {
            return resultFail("屈臣氏虚拟商品接口响应为空");
        }
        try {
            JSONObject originJson = JSON.parseObject(body);
            Boolean isSuccess = originJson.getBoolean("is_success");
            if (isSuccess) {
                return resultSuccessWithData(originJson.getString("data"));
            } else {
                return resultFail(originJson.getString("message"));
            }
        } catch (Exception e) {
            LOGGER.warn("[WatsonsApi-getVirtualRespone]屈臣氏-响应JSON解析错误:", e);
            return resultFail("屈臣氏响应JSON解析错误");
        }
    }

    private String resultFail(String message) {
        JSONObject result = new JSONObject();
        result.put("status", "fail");
        result.put("errorMessage", message);
        return result.toJSONString();
    }

    private String resultSuccessWithData(String data) {
        JSONObject result = new JSONObject();
        result.put("status", "success");
        result.put("data", data);
        return result.toJSONString();
    }
}

