package cn.com.duiba.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;

/**
 * Created with IntelliJ IDEA.
 * Description:
 * CreatedBy: fengchao
 * Date: 2020-04-27
 * Time: 1:56 PM
 */
@Configuration
@RefreshScope
public class SinaCreditsConfig {

    /**
     * 新浪微博转账操作-接口URL
     */
    @Value("${sina.credits.operate.url}")
    private String url;

    /**
     * 新浪微博转账操作-默认转账类型：1-积分发放，2-奖励，默认2。
     */
    @Value("${sina.credits.operate.default.type}")
    private String defaultType;

    /**
     * 新浪微博转账操作-默认转账描述
     */
    @Value("${sina.credits.operate.default.subject}")
    private String defaultSubject;

    /**
     * 新浪微博转账操作-应用名称
     */
    @Value("${sina.credits.operate.source}")
    private String source;

    /**
     * 新浪微博转账操作-签名密钥
     */
    @Value("${sina.credits.operate.secert.key}")
    private String secertKey;

    /**
     * 新浪微博转账操作-商户ID
     */
    @Value("${sina.credits.operate.grant.uid}")
    private String grantUid;

    public String getUrl() {
        return url;
    }
    public void setUrl(String url) {
        this.url = url;
    }


    public String getDefaultType() {
        return defaultType;
    }

    public void setDefaultType(String defaultType) {
        this.defaultType = defaultType;
    }

    public String getDefaultSubject() {
        return defaultSubject;
    }

    public void setDefaultSubject(String defaultSubject) {
        this.defaultSubject = defaultSubject;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSecertKey() {
        return secertKey;
    }

    public void setSecertKey(String secertKey) {
        this.secertKey = secertKey;
    }

    public String getGrantUid() {
        return grantUid;
    }

    public void setGrantUid(String grantUid) {
        this.grantUid = grantUid;
    }
}
