package cn.com.duiba.constant;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

/**
 * @program: thirdparty-all
 * @description: 贝因美配置
 * @author: Simba
 * @create: 2020-01-07 16:27
 **/
@Configuration
@ConfigurationProperties(prefix = "beingmate")
public class BeingmateConfig {

    private Set<Long> appIds;

    private String appKey = "duibatest";

    private String appSecret = "qMJlkHjKwOMYQQO4";
    /**
     * 获取token的url
     */
    private String jwttokenUrl = "http://openapi-test.beingmate.com:5000/api/sys/login/jwttoken";

    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public String getJwttokenUrl() {
        return jwttokenUrl;
    }

    public void setJwttokenUrl(String jwttokenUrl) {
        this.jwttokenUrl = jwttokenUrl;
    }

    public Boolean beLongToBeingmate(Long appId) {
        return appIds != null && appIds.contains(appId);
    }
}

