package cn.com.duiba.constant;

import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author fja
 */
@Configuration
@ConfigurationProperties(prefix = "delay.notify")
public class DelayNotifyConfig {
    private static final Map<Long, Integer> DELAY_LEVELS = new ConcurrentHashMap<>(256);
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiStrategyRouter.class);
    /**
     * 应用id集合
     */
    private Set<Long> appIds = Sets.newHashSet(-1L);

    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    /**
     * 是否需要延时通知
     *
     * @param appId -
     * @return
     */
    public boolean ifNeedDelay(Long appId) {
        return appIds.contains(appId);
    }

    /**
     * 注册延时档位
     *
     * @param appIds app集合
     * @param delayLevel 延时档位
     */
    public static void setDelayLevels(Set<Long> appIds, Integer delayLevel) {
        for(Long appId: appIds) {
            DELAY_LEVELS.put(appId, delayLevel);
        }
        LOGGER.info("通知消息延时配置 DELAY_LEVELS = {}", JSON.toJSONString(DELAY_LEVELS));
    }

    /**
     * 根据appId取出延时的档位
     *
     * @param appId -
     * @return
     */
    public static Integer getDelayLevels(Long appId) {
        return DELAY_LEVELS.get(appId);
    }
}
