package cn.com.duiba.constant;

import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.biz.credits.strategy.Impl.LenovoApiStrategy;
import com.google.common.collect.Sets;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

/**
 * @author chenhang
 * @date 2021/7/22 3:24 下午
 */
@Configuration
@ConfigurationProperties(prefix = "lenovo")
public class LenovoConfig implements InitializingBean {
    /**
     * 应用id集合
     */
    private Set<Long> appIdSet = Sets.newHashSet(84373L,84929L);

    //联想兑换纪录同步url
    private String crecordNotifyUrl = "";

    @Autowired
    private LenovoApiStrategy lenovoApiStrategy;

    public Set<Long> getAppIdSet() {
        return appIdSet;
    }

    public void setAppIdSet(Set<Long> appIdSet) {
        this.appIdSet = appIdSet;
    }

    public String getCrecordNotifyUrl() {
        return crecordNotifyUrl;
    }

    public void setCrecordNotifyUrl(String crecordNotifyUrl) {
        this.crecordNotifyUrl = crecordNotifyUrl;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        ApiStrategyRouter.register(getAppIdSet(), lenovoApiStrategy);
    }
}
