package cn.com.duiba.constant;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;

/**
 * @Description 银联积点虚拟商品配置
 * @Date 2022/3/2
 * @Author WeiChaoChao
 */
@Configuration
@ConfigurationProperties(prefix = "union.jidian")
@RefreshScope
public class UnionJiDianConstant {
    /**
     * 积点虚拟商品前缀
     */
    private String virtualPre = "UnionJiDian_";
    /**
     * 银联赠送积点请求url
     */
    private String jiDianSendUrl = "https://open.95516.com/open/access/1.0/memberPointAcquire";
    /**
     * 开发者业务类型对应的积点相关配置
     *
     * @see cn.com.duiba.vo.union.UnionJiDianConfig
     */
    private String miniAppConfigs = "";

    public String getJiDianSendUrl() {
        return jiDianSendUrl;
    }

    public void setJiDianSendUrl(String jiDianSendUrl) {
        this.jiDianSendUrl = jiDianSendUrl;
    }

    public String getMiniAppConfigs() {
        return miniAppConfigs;
    }

    public void setMiniAppConfigs(String miniAppConfigs) {
        this.miniAppConfigs = miniAppConfigs;
    }

    public String getVirtualPre() {
        return virtualPre;
    }

    public void setVirtualPre(String virtualPre) {
        this.virtualPre = virtualPre;
    }
}
