package cn.com.duiba.constant;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;

/**
 * @Description 银联红包虚拟商品配置
 * @Date 2022/3/2
 * @Author WeiChaoChao
 */
@Configuration
@ConfigurationProperties(prefix = "union.red")
@RefreshScope
public class UnionRedConstant {
    /**
     * 银联红包虚拟商品前缀
     */
    private String virtualPre = "UnionRed_";
    /**
     * 银联赠送红包请求url
     */
    private String redSendUrl = "https://open.95516.com/open/access/1.0/point.acquire";
    /**
     * 开发者业务类型对应的红包相关配置
     *
     * @see cn.com.duiba.vo.union.UnionRedConfig
     */
    private String miniAppConfigs = "";

    public String getRedSendUrl() {
        return redSendUrl;
    }

    public void setRedSendUrl(String redSendUrl) {
        this.redSendUrl = redSendUrl;
    }

    public String getMiniAppConfigs() {
        return miniAppConfigs;
    }

    public void setMiniAppConfigs(String miniAppConfigs) {
        this.miniAppConfigs = miniAppConfigs;
    }

    public String getVirtualPre() {
        return virtualPre;
    }

    public void setVirtualPre(String virtualPre) {
        this.virtualPre = virtualPre;
    }
}
