package cn.com.duiba.dao.custom.impl;

import cn.com.duiba.constant.DatabaseSchema;
import cn.com.duiba.dao.BaseDAO;
import cn.com.duiba.dao.custom.ReconciliationRecordDao;
import cn.com.duiba.thirdparty.dto.reconciliation.ReconciliationRecordDto;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository
public class ReconciliationRecordDaoImpl extends BaseDAO implements ReconciliationRecordDao {

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.DUIBA_CUSTOM;
    }

    @Override
    public Long insert(ReconciliationRecordDto entity){
        insert("insert", entity);
        return entity.getId();
    }

    @Override
    public int update(ReconciliationRecordDto entity){
        return update("update", entity);
    }

    @Override
    public List<ReconciliationRecordDto> findByUidOrderNum(String orderNum, Long appId, String uid, Integer logType, String optId, String optType){
        Map<String, Object> paramMap = new HashMap();
        paramMap.put("orderNum", orderNum);
        paramMap.put("appId", appId);

        if(StringUtils.isNotBlank(uid)){
            paramMap.put("uid", uid);
        }

        paramMap.put("logType", logType);

        if(StringUtils.isNotBlank(optId)){
            paramMap.put("optId", optId);
        }

        if(StringUtils.isNotBlank(optType)){
            paramMap.put("optType", optType);
        }

        return selectList("findByUidOrderNum", paramMap);
    }

//    @Override
//    public List<ReconciliationRecordDto> findRecordBySendTime(ReconciliationRecordParam creditRecordParam){
//        Map<String, Object> paramMap = queryParamMap(creditRecordParam);
//        paramMap.put("offset", creditRecordParam.getOffset());
//        paramMap.put("pageSize", creditRecordParam.getPageSize());
//        return selectList("findRecordBySendTime", paramMap);
//    }
//
//    @Override
//    public int findRecordCountBySendTime(ReconciliationRecordParam creditRecordParam) {
//        Map<String, Object> paramMap = queryParamMap(creditRecordParam);
//        return selectOne("findRecordCountBySendTime", paramMap);
//    }
//
//    @NotNull
//    private Map<String, Object> queryParamMap(ReconciliationRecordParam creditRecordParam) {
//        Map<String, Object> paramMap = new HashMap();
//        paramMap.put("startTime", creditRecordParam.getStartTime());
//        paramMap.put("endTime", creditRecordParam.getEndTime());
//        if(creditRecordParam.getAppId() != null){
//            paramMap.put("appId", creditRecordParam.getAppId());
//        }
//        if(CollectionUtils.isNotEmpty(creditRecordParam.getLogTypes())){
//            paramMap.put("logTypes", creditRecordParam.getLogTypes());
//        }
//        return paramMap;
//    }
}
