package cn.com.duiba.service.impl;

import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.service.AppService;
import cn.com.duiba.dto.AppSimpleDto;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;

/**
 * Created by fangdong on 2018/10/19
 */
@Service("appService")
public class AppServiceImpl implements AppService {

    @Resource
    private AppDAO appDAO;

    @Override
    public AppSimpleDto getById(Long id) {
        Assert.notNull(id, "id不能为null");

        AppDO entity = appDAO.getAppByCache(id);
        if (entity == null) {
            return null;
        }
        return BeanUtils.copy(entity, AppSimpleDto.class);
    }

}
