package cn.com.duiba.service.virtual.impl;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.config.PuShangConfig;
import cn.com.duiba.constant.BiliBiliConfig;
import cn.com.duiba.service.impl.AbstractDuibaVirtualSupplier;
import cn.com.duiba.service.virtual.impl.dto.PuShangResponse;
import cn.com.duiba.service.virtual.impl.dto.pushang.CommonResponse;
import cn.com.duiba.thirdparty.dto.SupplierRequestDto;
import cn.com.duiba.thirdparty.enums.virtual.VirtualItemChannelEnum;
import cn.com.duiba.tool.MD5;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

/**
 * @Auther: dingshitai
 * @Date: 2021/7/19 15:24
 * @Description:
 */
@Service
public class PuShangApiStrategy extends AbstractDuibaVirtualSupplier implements InitializingBean {
    /**
     * 日志
     */
    private static final Logger log = LoggerFactory.getLogger(PuShangApiStrategy.class);

    private static final String LOGGER_PREFIX = "浦上虚拟商品对接";

    private static final Long SUCCESS = 0L;

    private static final Long FAIL = 1L;

    @Autowired
    private PuShangConfig puShangConfig;
    private Map<String, Function<SupplierRequestDto, HttpRequestBase>> functionMap = Maps.newHashMap();
    private Map<String, Function<CommonResponse, String>> responseFunctionMap = Maps.newHashMap();


    private static final String Error4ConsumerMessage = "出了点小问题，请重新下单";

    @Override
    public void afterPropertiesSet() throws Exception {
        // 请求参数处理
        functionMap.put("11", this::getTianMaoRequest);
        functionMap.put("14", this::getNaiXueRequest);
        functionMap.put("17", this::getZFBRequest);
        functionMap.put("6", this::getVideoRequest);

        // 返回参数处理
        responseFunctionMap.put("11", this::commonResponse);
        responseFunctionMap.put("14", this::commonResponse);
        responseFunctionMap.put("17", this::commonResponse);
        responseFunctionMap.put("6", this::commonResponse);
    }

    /**
     * 构造请求  天猫淘享卡、购物券
     * @param request
     * @return
     */
    private HttpRequestBase getTianMaoRequest(SupplierRequestDto request) {
        Map<String, String> stringMap = request.getParams();
        String bizParams = stringMap.get("bizParams");
        // 商品编号
        String productId = bizParams.split("-")[1];
        // 购买人手机号
        String buyerNick = stringMap.get("account");
        // 商户订单号
        String extOrderId = stringMap.get("orderNum");
        // 结果通知地址
        String notifyUrl = puShangConfig.getNotifyUrl();
        // 商户ID
        String merchantId = puShangConfig.getMerchantId();
        String md5MerchantId = puShangConfig.getMd5MerchantId();

        // 顺序不能变
        String sourceSign = buyerNick + extOrderId + merchantId + notifyUrl + productId + md5MerchantId;

        // 加签
        String sign = "";
        try {
            sign = MD5.md5(sourceSign.getBytes());
        } catch (NoSuchAlgorithmException e) {
            log.error("加签失败 request = {}", JSON.toJSONString(request));
        }
        // 构建请求的入参
        Map<String, String> params = Maps.newHashMap();
        params.put("productId", productId);
        params.put("buyerNick", buyerNick);
        params.put("extOrderId", extOrderId);
        params.put("notifyUrl", notifyUrl);
        params.put("merchantId", merchantId);
        params.put("sign", sign);
        HttpPost httpPost = new HttpPost("http://api.yaajie.com:8080/api/tianMao/makeOrder" + "?productId="+productId+"&buyerNick="+buyerNick+"&extOrderId="+extOrderId+"&notifyUrl="+notifyUrl+"&merchantId="+merchantId+"&sign="+sign);
        httpPost.setEntity(new StringEntity(JSON.toJSONString(params), ContentType.APPLICATION_FORM_URLENCODED));
        return httpPost;
    }

    /**
     * 构造请求 奈雪直充卷
     * @param request
     * @return
     */
    private HttpRequestBase getNaiXueRequest(SupplierRequestDto request) {
        Map<String, String> stringMap = request.getParams();
        String bizParams = stringMap.get("bizParams");
        // 商品编号
        String productId = bizParams.split("-")[1];
        // 购买人手机号
        String buyerNick = stringMap.get("account");
        // 商户订单号
        String extOrderId = stringMap.get("orderNum");
        // 结果通知地址
        String notifyUrl = puShangConfig.getNotifyUrl();
        // 商户ID
        String merchantId = puShangConfig.getMerchantId();
        String md5MerchantId = puShangConfig.getMd5MerchantId();

        // 顺序不能变
        String sourceSign = buyerNick + productId + extOrderId + merchantId + notifyUrl  + md5MerchantId;

        // 加签
        String sign = "";
        try {
            sign = MD5.md5(sourceSign.getBytes());
        } catch (NoSuchAlgorithmException e) {
            log.error("加签失败 request = {}", JSON.toJSONString(request));
        }
        // 构建请求的入参
        Map<String, String> params = Maps.newHashMap();
        params.put("productId", productId);
        params.put("merchantId", merchantId);
        params.put("extOrderId", extOrderId);
        params.put("notifyUrl", notifyUrl);
        params.put("phoneNumber", buyerNick);
        params.put("sign", sign);
        HttpPost httpPost = new HttpPost("http://api.yaajie.com:8080/api/naiXue/makeOrder?" + "productId="+productId+"&merchantId="+merchantId+"&phoneNumber="+buyerNick+"&extOrderId="+extOrderId+"&notifyUrl="+notifyUrl+"&sign="+sign);
        httpPost.setEntity(new StringEntity(JSON.toJSONString(params), ContentType.APPLICATION_FORM_URLENCODED));
        return httpPost;
    }

    /**
     * 支付宝立减金直充
     * @param request
     * @return
     */
    private HttpRequestBase getZFBRequest(SupplierRequestDto request) {
        Map<String, String> stringMap = request.getParams();
        String bizParams = stringMap.get("bizParams");
        // 商品编号
        String productId = bizParams.split("-")[1];
        // 购买人手机号
        String buyerNick = stringMap.get("account");
        // 商户订单号
        String extOrderId = stringMap.get("orderNum");
        // 结果通知地址
        String notifyUrl = puShangConfig.getNotifyUrl();
        // 商户编号
        String merchantId = puShangConfig.getMerchantId();
        // 商户ID
        String md5MerchantId = puShangConfig.getMd5MerchantId();
        // 顺序不能变
        String sourceSign = extOrderId + buyerNick  + merchantId + productId + notifyUrl  + md5MerchantId;

        // 加签
        String sign = "";
        try {
            sign = MD5.md5(sourceSign.getBytes());
        } catch (NoSuchAlgorithmException e) {
            log.error("加签失败 request = {}", JSON.toJSONString(request));
        }
        // 构建请求的入参
        Map<String, String> params = Maps.newHashMap();
        params.put("extOrderId", extOrderId);
        params.put("incomeAccount", buyerNick);
        params.put("merchantId", merchantId);
        params.put("productId", productId);
        params.put("notifyUrl", notifyUrl);
        params.put("incomeRemark", "");
        params.put("incomeUserName", "");
        params.put("sign", sign);
        HttpPost httpPost = new HttpPost("http://api.yaajie.com:8080/api/zfb/act/makeOrder?"
                + "extOrderId="+extOrderId+"&incomeAccount="+buyerNick+"&merchantId="+merchantId+"&productId="+productId+"&notifyUrl="+notifyUrl+"&sign="+sign+"&incomeRemark=&incomeUserName=");
        httpPost.setEntity(new StringEntity(JSON.toJSONString(params), ContentType.APPLICATION_FORM_URLENCODED));
        return httpPost;
    }

    /**
     * 视频会员接口
     * @param request
     * @return
     */
    private HttpRequestBase getVideoRequest(SupplierRequestDto request) {
        Map<String, String> stringMap = request.getParams();
        String bizParams = stringMap.get("bizParams");
        // 商品编号
        String productId = bizParams.split("-")[1];
        // 购买人手机号
        String buyerNick = stringMap.get("account");
        // 商户订单号
        String extOrderId = stringMap.get("orderNum");
        // 结果通知地址
        String notifyUrl = puShangConfig.getNotifyUrl();
        // 商户编号
        String merchantId = puShangConfig.getMerchantId();
        // 商户ID
        String md5MerchantId = puShangConfig.getMd5MerchantId();
        // 顺序不能变
        String sourceSign = buyerNick + extOrderId + merchantId + notifyUrl + NumberUtils.LONG_ONE + productId + md5MerchantId;
        // 加签
        String sign = "";
        try {
            sign = MD5.md5(sourceSign.getBytes());
        } catch (NoSuchAlgorithmException e) {
            log.error("加签失败 request = {}", JSON.toJSONString(request));
        }
        // 构建请求的入参
        Map<String, String> params = Maps.newHashMap();
        params.put("productId", productId);
        params.put("merchantId", merchantId);
        params.put("extOrderId", extOrderId);
        params.put("notifyUrl", notifyUrl);
        params.put("account", buyerNick);
        params.put("number", NumberUtils.INTEGER_ONE.toString());
        params.put("sign", sign);
        HttpPost httpPost = new HttpPost("http://api.yaajie.com:8080/api/video/makeOrder?" +
                "merchantId="+merchantId+"&extOrderId="+extOrderId+"&productId="+productId+"&account="+buyerNick+"&number="+ NumberUtils.LONG_ONE +"&notifyUrl="+notifyUrl+"&sign="+sign);
        httpPost.setEntity(new StringEntity(JSON.toJSONString(params), ContentType.APPLICATION_FORM_URLENCODED));
        return httpPost;
    }
    /**
     * 构造请求
     * @param request
     * @return
     */
    @Override
    public HttpRequestBase getVirtualRequest(SupplierRequestDto request) {
        // 解析出url请求中的参数
        Map<String, String> originData = request.getParams();
        String bizParams = originData.get("bizParams");
        if (org.apache.commons.lang3.StringUtils.isBlank(bizParams)) {
            throw new ThirdpatyException("参数错误，没有对应的商品信息");
        }
        if (StringUtils.isEmpty(originData.get("account"))) {
            throw new ThirdpatyException("手机号信息必填");
        }
        String type = Arrays.stream(bizParams.split("-")).findFirst().orElse("");
        Function<SupplierRequestDto, HttpRequestBase> function = functionMap.get(type);
        if (Objects.isNull(function)) {
            throw new ThirdpatyException("调用方法异常");
        }
        HttpRequestBase httpRequestBase = function.apply(request);
        log.info("puShang 接口请求 httpRequestBase = {}", JSONUtil.toJsonStr(httpRequestBase));
        return httpRequestBase;
    }

    /**
     * 调用浦上订单接口返回结果判断解析
     * @param request
     * @param body
     * @return
     */
    @Override
    public String getVirtualResponse(SupplierRequestDto request, String body) {
        Map<String, String> originData = request.getParams();
        String bizParams = originData.get("bizParams");
        String type = Arrays.stream(bizParams.split("-")).findFirst().orElse("");
        Function<CommonResponse, String> function = responseFunctionMap.get(type);
        if (Objects.isNull(function)) {
            throw new ThirdpatyException("调用方法异常");
        }
        return function.apply(new CommonResponse(request, body));
    }

    private String commonResponse(CommonResponse commonResponse) {
        String body = commonResponse.getBody();
        SupplierRequestDto request = commonResponse.getRequest();
        Map<String,String> duibaDoc = Maps.newHashMap();
        if(StringUtils.isEmpty(body)){
            log.error(LOGGER_PREFIX+"请求下单失败！请求订单Id:{},返回的response解析为空",request.getOrderId());
            duibaDoc.put("status", "fail");
            return JSONObject.toJSONString(duibaDoc);
        }
        PuShangResponse puShangResponse = JSON.parseObject(body, PuShangResponse.class);
        if(SUCCESS.equals(puShangResponse.getCode())){
            log.info(LOGGER_PREFIX+"请求下单成功！请求订单Id:{},response={}",request.getOrderId(),JSONObject.toJSONString(puShangResponse));
            duibaDoc.put("status", "process");
            return JSONObject.toJSONString(duibaDoc);
        }else if(FAIL.equals(puShangResponse.getCode())){
            log.info(LOGGER_PREFIX+"请求下单失败！请求订单Id:{},失败原因是:{}",request.getOrderId(),puShangResponse.getMsg());
            duibaDoc.put("status", "fail");
            return JSONObject.toJSONString(duibaDoc);
        }else{
            log.error(LOGGER_PREFIX+"请求下单失败！出现未知回复,请求订单Id:{},response={}",request.getOrderId(),JSONObject.toJSONString(puShangResponse));
            duibaDoc.put("status", "fail");
            return JSONObject.toJSONString(duibaDoc);
        }
    }

    @Override
    public String getVirtualTypeCode() {
        return VirtualItemChannelEnum.PU_SHANG.getCode();
    }


    @Override
    public String getDefaultError4ConsumerMessage() {
        return Error4ConsumerMessage;
    }

}
