package cn.com.duiba.service.virtual.impl;

import cn.com.duiba.constant.YuShangConfig;
import cn.com.duiba.service.impl.AbstractDuibaVirtualSupplier;
import cn.com.duiba.thirdparty.dto.SupplierRequestDto;
import cn.com.duiba.thirdparty.enums.virtual.VirtualItemChannelEnum;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author qiurenjie
 * @date 2021-07-16 15:00
 */
@Service
public class YuShangApiStrategy extends AbstractDuibaVirtualSupplier {

    private static final Logger LOGGER = LoggerFactory.getLogger(YuShangApiStrategy.class);
    private static final String LOGGER_PREFIX = "娱尚虚拟商品接口";
    //9	重复提交订单且之前提交的订单在充值中  997	重复提交订单且之前提交的订单在充值成功
    private static final Set<Integer> processSet = Sets.newHashSet(9,997,999);

    @Autowired
    private YuShangConfig yuShangConfig;

    private static final String Error4ConsumerMessage = "出了点小问题，请重新下单";

    @Override
    public String getVirtualTypeCode() {
        return VirtualItemChannelEnum.SHANG_YU.getCode();
    }

    @Override
    public HttpRequestBase getVirtualRequest(SupplierRequestDto supplierRequest) {
        LOGGER.info(LOGGER_PREFIX + ",request={}", JSON.toJSONString(supplierRequest));
        //将请求URL的参数转换为MAP
        Map<String, String> params = supplierRequest.getParams();
        String goodsNum = params.get("bizParams");
        //兑吧订单号
        String orderNum = params.get("orderNum");
        //用户兑换虚拟商品时输入的账号
        String account = params.get("account");

        HttpPost httpPost = new HttpPost(yuShangConfig.getUrl());

        List<NameValuePair> pairs = Lists.newArrayList();
        pairs.add(new BasicNameValuePair("AppKey",yuShangConfig.getAppKey()));
        pairs.add(new BasicNameValuePair("TimesTamp", System.currentTimeMillis() + ""));
        pairs.add(new BasicNameValuePair("ProductCode", goodsNum));
        pairs.add(new BasicNameValuePair("MOrderID", orderNum));
        pairs.add(new BasicNameValuePair("ChargeAccount", account));
        pairs.add(new BasicNameValuePair("BuyCount", "1"));
        pairs.add(new BasicNameValuePair("CustomerIP", "114.55.126.253"));
        pairs.add(new BasicNameValuePair("CallBackUrl", yuShangConfig.getCallBackUrl()));
        pairs.add(new BasicNameValuePair("Sign", getSign(pairs)));
        httpPost.setEntity(new UrlEncodedFormEntity(pairs, Charset.forName("UTF-8")));
        return httpPost;
    }

    @Override
    public String getVirtualResponse(SupplierRequestDto request, String body) {
        LOGGER.info(LOGGER_PREFIX + ",请求返回结果处理,request:{},body:{}", JSONObject.toJSONString(request), body);
        JSONObject result = new JSONObject();
        try {
            JSONObject responseJson = JSONObject.parseObject(body);
            Integer responseCode = responseJson.getInteger("Code");
            if(processSet.contains(responseCode)) {
                result.put("status", "process");
            } else {
                result.put("status", "fail");
                result.put("errorMessage", responseJson.getString("Msg"));
            }
        } catch (Exception e) {
            result.put("status", "fail");
            result.put("errorMessage", e.getMessage());
            LOGGER.info(LOGGER_PREFIX + ",解析虚拟商品兑换请求结果异常,orderId=" + request.getOrderId(), e);
        }
        return result.toJSONString();
    }

    @Override
    public String getDefaultError4ConsumerMessage() {
        return Error4ConsumerMessage;
    }


    private String getSign(List<NameValuePair> pairs) {
        List<String> valueList = pairs.stream().sorted(Comparator.comparing(NameValuePair::getName))
                .map(NameValuePair::getValue).collect(Collectors.toList());
        String result = StringUtils.join(valueList, "") + yuShangConfig.getAppSecret();
        return toHexValue(encryptMD5(result.getBytes()));
    }
    public static byte[] encryptMD5(byte[] data){
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        } catch (NoSuchAlgorithmException e) {
        }
        md5.update(data);
        return md5.digest();
    }
    public static String toHexValue(byte[] messageDigest) {
        if (messageDigest == null) {
            return "";
        }
        StringBuilder hexValue = new StringBuilder();
        for (byte aMessageDigest : messageDigest) {
            int val = 0xFF & aMessageDigest;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString().toUpperCase();
    }
}
