package cn.com.duiba.service.virtualsupplierprocess;

import cn.com.duiba.domain.VirtualSupplierProcessingOrderLogEntity;

import java.util.List;

/**
 * @author haojiahong
 * @date 2020-07-24
 */
public interface VirtualSupplierProcessOrderService {

    /**
     * 初始化保存，记录相关信息
     *
     * @param entity
     */
    void initSave(VirtualSupplierProcessingOrderLogEntity entity);

    /**
     * 根据appId，orderId删除记录
     *
     * @param appId
     * @param orderId
     */
    void deleteByAppIdOrderId(Long appId, Long orderId);


    /**
     * 更新记录
     *
     * @param entity
     */
    void updateById(VirtualSupplierProcessingOrderLogEntity entity);


    /**
     * 删除记录
     *
     * @param id
     */
    void deleteById(Long id);

    /**
     * 查询中间状态的订单
     * gmt_create 15分钟之内
     * process_status 为0
     * has_query_times 小于3次
     *
     * @return
     */
    List<VirtualSupplierProcessingOrderLogEntity> selectNeedRepeatQueryList(Long appId, int offset, int pageSize);

    Integer countNeedRepeatQuery(Long appId);


    VirtualSupplierProcessingOrderLogEntity getById(Long id);


}
