package cn.com.duiba.service.virtualsupplierprocess.impl;

import cn.com.duiba.dao.custom.VirtualSupplierProcessingOrderLogDao;
import cn.com.duiba.domain.VirtualSupplierProcessingOrderLogEntity;
import cn.com.duiba.service.virtualsupplierprocess.VirtualSupplierProcessOrderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author haojiahong
 * @date 2020-07-24
 */
@Service
public class VirtualSupplierProcessOrderServiceImpl implements VirtualSupplierProcessOrderService {

    @Autowired
    private VirtualSupplierProcessingOrderLogDao virtualSupplierProcessingOrderLogDao;


    @Override
    public void initSave(VirtualSupplierProcessingOrderLogEntity entity) {
        entity.setHasQueryTimes(0);
        entity.setProcessStatus(0);
        virtualSupplierProcessingOrderLogDao.save(entity);
    }

    @Override
    public void deleteByAppIdOrderId(Long appId, Long orderId) {
        virtualSupplierProcessingOrderLogDao.deleteByAppIdOrderId(appId, orderId);
    }

    @Override
    public void updateById(VirtualSupplierProcessingOrderLogEntity entity) {
        virtualSupplierProcessingOrderLogDao.updateById(entity);
    }

    @Override
    public void deleteById(Long id) {
        virtualSupplierProcessingOrderLogDao.deleteById(id);
    }

    @Override
    public List<VirtualSupplierProcessingOrderLogEntity> selectNeedRepeatQueryList(Long appId, int offset, int pageSize) {
        return virtualSupplierProcessingOrderLogDao.selectNeedRepeatQueryList(appId, offset, pageSize);
    }

    @Override
    public Integer countNeedRepeatQuery(Long appId) {
        return virtualSupplierProcessingOrderLogDao.countNeedRepeatQuery(appId);
    }

    @Override
    public VirtualSupplierProcessingOrderLogEntity getById(Long id) {
        return virtualSupplierProcessingOrderLogDao.getById(id);
    }


}
