package cn.com.duiba.tool.cgb;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public final class FileHelper {

	private static final int BUFFSIZE = 0x10000;

	private FileHelper() {
	}

	public static final void write(String filePath, byte data[])
			throws IOException {
		if (filePath == null) {
			throw new IllegalArgumentException("Illegal Argument: filePath");
		}
		if (data == null) {
			throw new IllegalArgumentException("Illegal Argument: data");
		}
		try (FileOutputStream fos = new FileOutputStream(filePath)) {
			fos.write(data, 0, data.length);
			fos.flush();
		}
	}

	public static final byte[] read(String filePath) throws IOException {
		if (filePath == null) {
			throw new IllegalArgumentException("Illegal Argument: filePath");
		}
		try (FileInputStream crls = new FileInputStream(filePath)) {
			byte out[] = new byte[crls.available()];
			byte buffer[] = new byte[BUFFSIZE];
			int rLength;
			for (int offset = 0; (rLength = crls.read(buffer, 0, buffer.length)) != -1; offset += rLength) {
				System.arraycopy(buffer, 0, out, offset, rLength);
			}
			return out;
		}
	}

	public static final byte[] read(InputStream in) throws IOException {
		if (in == null) {
			throw new IllegalArgumentException("Illegal Argument: in");
		}
		byte out[];
		out = new byte[in.available()];
		byte buffer[] = new byte[BUFFSIZE];
		int rLength;
		for (int offset = 0; (rLength = in.read(buffer, 0, buffer.length)) != -1; offset += rLength) {
			System.arraycopy(buffer, 0, out, offset, rLength);
		}
		return out;
	}
}
