package cn.com.duiba.tool.puhui;

import cn.com.duiba.wolf.utils.BeanUtils;
import cn.hutool.crypto.digest.MD5;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

import java.util.*;

/**
 * @author fja
 */
public class PuhuiUtils {

    public static String signToRequest(Map<String, String> params, String secret) {
        // 第一步：检查参数是否已经排序
        String[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);

        // 第二步：把所有参数名和参数值串在一起
        StringBuilder query = new StringBuilder();
        query.append(secret);

        for (String key : keys) {
            String value = params.get(key);
            if (StringUtils.isNoneBlank(key, value)) {
                query.append(key).append(value);
            }
        }
        // 第三步：使用MD5加密,并把二进制转化为大写的十六进制(正确签名应该为32大写字符串，此方法需要时使用)
        query.append(secret);
        return MD5.create().digestHex(String.valueOf(query)).toUpperCase();
    }


    /**
     * 转string
     *
     * @param param
     * @return
     */
    public static Map<String, String> createStrMap(Object param) {
        Map<String, Object> map = BeanUtils.transBeanToMap(param);
        Map<String, String> paramStr = new HashMap<>();
        for (Map.Entry<String, Object> m : map.entrySet()) {
            if (org.apache.commons.lang3.StringUtils.isNotBlank(m.getKey()) && m.getValue() != null) {
                paramStr.put(m.getKey(), String.valueOf(m.getValue()));
            }
        }
        return paramStr;
    }


    public static Header[] getHeaders(Map<String, String> headerMap) {
        List<BasicHeader> basicHeaders = new ArrayList<>();
        for (Map.Entry<String, String> m : headerMap.entrySet()) {
            if (org.apache.commons.lang3.StringUtils.isNotBlank(m.getKey()) && m.getValue() != null) {
                basicHeaders.add(new BasicHeader(m.getKey(), m.getValue()));
            }
        }
        return basicHeaders.toArray(new Header[0]);
    }
}
