/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.constant.GuMingConstant;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.GuMingSignTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class GuMingApi {
    private static final Logger log = LoggerFactory.getLogger(GuMingApi.class);
    @Resource
    private GuMingConstant guMingConstant;

    public boolean isGuMing(Long appId) {
        return Objects.equals(this.guMingConstant.getAppId(), appId);
    }

    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf(63));
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> authParams = AssembleTool.getUrlParams(paramsStr);
        HashMap newAuthParams = Maps.newHashMap();
        newAuthParams.put("channel", "2");
        newAuthParams.put("note", authParams.get("description"));
        newAuthParams.put("template_id", authParams.get("params"));
        newAuthParams.put("uid", authParams.get("uid"));
        newAuthParams.put("out_trade_no", authParams.get("orderNum"));
        newAuthParams.put("mid", this.guMingConstant.getMid());
        request.setHttpUrl(newUrl);
        request.setAuthParams(newAuthParams);
        HashMap bodyRequest = Maps.newHashMap((Map)newAuthParams);
        bodyRequest.put("channel", 2);
        HashMap body = Maps.newHashMap();
        body.put("method", "coupon_send");
        body.put("coupon_send_request", bodyRequest);
        return this.getHttpPost(newUrl, JSON.toJSONString((Object)body));
    }

    public String getVirtualResponse(SupplierRequest message, String body) {
        log.info("\u53e4\u8317\u865a\u62df\u5546\u54c1\u5145\u503c\u54cd\u5e94\u7ed3\u679cresponse, body={}", (Object)body);
        JSONObject jsonBody = JSON.parseObject((String)body);
        JSONObject result = new JSONObject();
        if (!Objects.equals(0, jsonBody.getInteger("status"))) {
            result.put("status", (Object)"fail");
            result.put("errorMessage", (Object)jsonBody.getString("msg"));
            return result.toString();
        }
        result.put("status", (Object)"success");
        return result.toString();
    }

    private HttpRequestBase getHttpPost(String httpUrl, String jsonBody) {
        String urlPath = UriComponentsBuilder.fromHttpUrl((String)httpUrl).build().getPath();
        HttpPost request = new HttpPost(httpUrl);
        request.setEntity((HttpEntity)new StringEntity(jsonBody, ContentType.APPLICATION_JSON));
        Map<String, String> headers = GuMingSignTool.getSignHeaders(urlPath, jsonBody, this.guMingConstant.getDeveloperAppKey(), this.guMingConstant.getDeveloperAppSecret());
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            request.setHeader(entry.getKey(), entry.getValue());
        }
        return request;
    }
}

