/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.HeBeiMobileConfig;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class HeBeiMobileApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeBeiMobileApi.class);
    @Autowired
    private HeBeiMobileConfig heBeiMobileConfig;
    @Resource(name="stringRedisTemplate")
    private StringRedisTemplate stringRedisTemplate;
    @Resource(name="httpClient")
    private CloseableHttpClient httpClient;
    private static final String TOKEN_CACHE_KEY = "heBeiMobileToken_";

    public boolean isHeBeiMobile(Long appId) {
        return this.heBeiMobileConfig.isHeBeiMobile(appId);
    }

    private String getTokenCacheKey(Long appId) {
        return TOKEN_CACHE_KEY + appId;
    }

    private String getToeknByCache(Long appId) {
        String token;
        if (!this.heBeiMobileConfig.isHeBeiMobile(appId)) {
            return null;
        }
        String key = this.getTokenCacheKey(appId);
        if (this.heBeiMobileConfig.getTokenByCache().booleanValue() && StringUtils.isNotBlank((CharSequence)(token = (String)this.stringRedisTemplate.opsForValue().get((Object)key)))) {
            return token;
        }
        token = this.getTokenHttp();
        if (StringUtils.isNotBlank((CharSequence)token)) {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)token, 20L, TimeUnit.MINUTES);
        }
        return token;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getTokenHttp() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ASKACC", this.heBeiMobileConfig.getAskacc());
        params.put("ASKPWD", this.heBeiMobileConfig.getAskcode());
        params.put("CHANNEL_CODE", this.heBeiMobileConfig.getChannelCode());
        params.put("REQURL", this.heBeiMobileConfig.getRequestUrlToken());
        String url = this.heBeiMobileConfig.getUrl();
        LOGGER.info("\u6cb3\u5317\u79fb\u52a8-\u83b7\u53d6token\u63a5\u53e3\uff0c\u8bf7\u6c42url:{}, \u53c2\u6570params:{}", (Object)url, JSON.toJSON(params));
        HttpPost httpPost = new HttpPost(url);
        StringEntity stringEntity = new StringEntity(JSON.toJSONString(params), "UTF-8");
        httpPost.setEntity((HttpEntity)stringEntity);
        String token = null;
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);){
            LOGGER.info("\u6cb3\u5317\u79fb\u52a8-\u83b7\u53d6token-\u8fd4\u56deresponse:{}", JSON.toJSON((Object)response));
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                String string = null;
                return string;
            }
            String result = EntityUtils.toString((HttpEntity)entity);
            LOGGER.info("\u6cb3\u5317\u79fb\u52a8-\u83b7\u53d6token-\u8fd4\u56deHttpEntity:{}", (Object)result);
            token = this.parseTokenResponse(result);
            return token;
        }
        catch (IOException e) {
            LOGGER.warn("\u53d1\u9001\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
        return token;
    }

    private String parseTokenResponse(String result) {
        JSONObject responseBody;
        try {
            responseBody = JSON.parseObject((String)result);
        }
        catch (Exception e) {
            LOGGER.warn("\u6cb3\u5317\u79fb\u52a8-\u89e3\u6790\u8fd4\u56de\u6570\u636e\uff0cresult:{}, JSON.parseObject:", (Object)result, (Object)e);
            return null;
        }
        JSONObject resultObj = responseBody.getJSONObject("resultObj");
        if (null != resultObj) {
            return resultObj.getString("TOKEN");
        }
        return null;
    }

    public SupplierRequest getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String authParams = url.substring(url.indexOf(63) + 1);
        Map<String, String> requestParams = this.buildVirtualRequestParams(Long.valueOf(request.getAppId()), authParams);
        request.setHttpUrl(this.heBeiMobileConfig.getUrl());
        request.setAuthParams(requestParams);
        return request;
    }

    private Map<String, String> buildVirtualRequestParams(Long appId, String authParams) {
        Map<String, String> authParamMap = AssembleTool.getUrlParams(authParams);
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("ASKACC", this.heBeiMobileConfig.getAskacc());
        requestParams.put("ASKPWD", this.heBeiMobileConfig.getAskcode());
        requestParams.put("CHANNEL_CODE", this.heBeiMobileConfig.getChannelCode());
        requestParams.put("REQURL", this.heBeiMobileConfig.getRequestUrlSendCard());
        requestParams.put("Prize_id", authParamMap.get("params"));
        requestParams.put("MOBILE", authParamMap.get("uid"));
        requestParams.put("date", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        requestParams.put("order_id", authParamMap.get("orderNum"));
        requestParams.put("TOKEN", this.getToeknByCache(appId));
        return requestParams;
    }

    public String getVirtualResponse(SupplierRequest message, String body) {
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        try {
            JSONObject resultJson = JSON.parseObject((String)body);
            if (null == resultJson) {
                throw new BizException("\u6cb3\u5317\u79fb\u52a8-\u865a\u62df\u5546\u54c1\u53d1\u5956-\u5f00\u53d1\u8005\u63a5\u53e3\u54cd\u5e94\u5185\u5bb9\u5f02\u5e38");
            }
            String status = resultJson.getString("resultCode");
            if (!Objects.equals("0", status)) {
                throw new BizException(resultJson.getString("resultMsg"));
            }
            duibaDoc.put("status", "success");
            duibaDoc.put("data", body);
        }
        catch (Exception e) {
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", e.getMessage());
            LOGGER.info("[HeBeiMobileApi-getVirtualResponse] Params:[message={},body={}], Msg:\u6cb3\u5317\u79fb\u52a8-\u865a\u62df\u5546\u54c1\u63a5\u53e3\u54cd\u5e94\u89e3\u6790\u5f02\u5e38", new Object[]{JSON.toJSON((Object)message), body, e});
        }
        return JsonTool.objectToJson(duibaDoc);
    }
}

