/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.constant.HuaweiConfig;
import cn.com.duiba.credits.sdk.AddCreditsParams;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.huawei.SignUtils;
import cn.com.duiba.tool.huawei.UrlUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.duiba.wolf.utils.UrlUtils2;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HuaweiApi {
    private static final Logger LOG = LoggerFactory.getLogger(HuaweiApi.class);
    private static final String VIRTUAL_TYPE_KEY = "virtualType";
    private static final ImmutableSet<String> SOURCE_TYPE = ImmutableSet.of((Object)"reSign", (Object)"sign");
    @Autowired
    private HuaweiConfig huaweiConfig;

    public boolean isHuaweiApp(Long appId) {
        return this.huaweiConfig.isHuaweiApp(appId);
    }

    public HttpRequestBase getSubCreditsHttpRequest(CreditsMessage message) {
        try {
            String url = UrlUtils2.extractUrl((String)message.getHttpUrl());
            Map<String, String> requestParams = this.buildConsumeCreditsParams(message.getHttpUrl());
            HttpRequestBase result = this.buildJsonRequest(url, requestParams);
            message.setHttpUrl(url);
            message.setAuthParams(requestParams);
            LOG.info("huawei \u6263\u79ef\u5206\u8bf7\u6c42\n\nurl:\n{}\n\nparams:\n{}\n\nheaders:\n{}", new Object[]{message.getHttpUrl(), JSON.toJSONString(requestParams), JSON.toJSONString(this.headerMap(result.getAllHeaders()))});
            return result;
        }
        catch (Exception e) {
            LOG.error("huawei \u521b\u5efa\u6263\u79ef\u5206\u8bf7\u6c42\u5f02\u5e38 message={}", (Object)JSON.toJSONString((Object)message), (Object)e);
            throw new IllegalStateException(e);
        }
    }

    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        try {
            String url = UrlUtils2.extractUrl((String)message.getHttpUrl());
            Map<String, String> requestParams = this.buildConsumeCreditsParams(message.getHttpUrl());
            HttpRequestBase result = this.buildJsonRequest(url, requestParams);
            message.setHttpUrl(url);
            message.getSubCreditsMsg().setAuthParams(requestParams);
            LOG.info("huawei \u6263\u79ef\u5206\u8bf7\u6c42\n\nurl:\n{}\n\nparams:\n{}\n\nheaders:\n{}", new Object[]{message.getHttpUrl(), JSON.toJSONString(requestParams), JSON.toJSONString(this.headerMap(result.getAllHeaders()))});
            return result;
        }
        catch (Exception e) {
            LOG.error("huawei \u521b\u5efa\u6263\u79ef\u5206\u8bf7\u6c42\u5f02\u5e38 message={}", (Object)JSON.toJSONString((Object)message), (Object)e);
            throw new IllegalStateException(e);
        }
    }

    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        try {
            String url = UrlUtils2.extractUrl((String)message.getHttpUrl());
            Map<String, String> requestParams = this.buildAddCreditsParams(message.getHttpUrl(), message.getAddCreditsParams());
            HttpRequestBase result = this.buildJsonRequest(url, requestParams);
            message.setHttpUrl(url);
            message.setAuthParams(requestParams);
            LOG.info("huawei \u52a0\u79ef\u5206\u8bf7\u6c42\n\nurl:\n{}\n\nparams:\n{}\n\nheaders:\n{}", new Object[]{message.getHttpUrl(), JSON.toJSONString(requestParams), JSON.toJSONString(this.headerMap(result.getAllHeaders()))});
            return result;
        }
        catch (Exception e) {
            LOG.error("huawei \u521b\u5efa\u52a0\u79ef\u5206\u8bf7\u6c42\u5f02\u5e38 message={}", (Object)JSON.toJSONString((Object)message), (Object)e);
            throw new IllegalStateException(e);
        }
    }

    public String parseCreditsResponse(String body, Boolean addCredits) {
        LOG.info("huawei {}\u79ef\u5206\u54cd\u5e94\u7ed3\u679c\n{}", (Object)(addCredits != false ? "\u52a0" : "\u6263"), (Object)body);
        JSONObject result = new JSONObject();
        try {
            JSONObject json = JSON.parseObject((String)body);
            if (json.getBooleanValue("success") && "0".equals(json.getString("code"))) {
                result.put("status", (Object)"ok");
                result.put("bizId", (Object)(System.currentTimeMillis() + RandomStringUtils.randomNumeric((int)6)));
            } else {
                result.put("status", (Object)"fail");
                result.put("errorMessage", (Object)json.getString("msg"));
            }
        }
        catch (Exception e) {
            LOG.error("huawei \u89e3\u6790{}\u79ef\u5206\u54cd\u5e94\u7ed3\u679c\u5f02\u5e38 response={}", new Object[]{addCredits != false ? "\u52a0" : "\u6263", body, e});
            result.put("status", (Object)"fail");
            result.put("errorMessage", (Object)"\u89e3\u6790\u54cd\u5e94\u7ed3\u679c\u5f02\u5e38");
        }
        return result.toJSONString();
    }

    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        try {
            Map<String, String> params = UrlUtils.extractUrlParamsFromUrl(request.getHttpUrl());
            Pair<String, String> thirdCode = this.parseThirdCode(params.get("params"));
            String domain = UrlUtils2.extractUrl((String)request.getHttpUrl());
            HttpRequestBase result = this.buildVirtualRequestByType(request, domain, params, (String)thirdCode.getLeft(), (String)thirdCode.getRight());
            LOG.info("huawei \u865a\u62df\u5546\u54c1\u5145\u503c\u8bf7\u6c42\n\nurl:\n{}\n\nparams:\n{}\n\nheaders:\n{}", new Object[]{request.getHttpUrl(), JSON.toJSONString(request.getAuthParams()), JSON.toJSONString(this.headerMap(result.getAllHeaders()))});
            return result;
        }
        catch (Exception e) {
            LOG.error("huawei \u521b\u5efa\u865a\u62df\u5546\u54c1\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38 request={}", (Object)JSON.toJSONString((Object)request), (Object)e);
            throw new IllegalStateException(e);
        }
    }

    public String getVirtualResponse(SupplierRequest request, String body) {
        try {
            String type = request.getParams().get(VIRTUAL_TYPE_KEY);
            LOG.info("huawei \u865a\u62df\u5546\u54c1\u5145\u503c\u54cd\u5e94\u7ed3\u679c\n\ntype:\n{}\n\nresponse:\n{}", (Object)type, (Object)body);
            return this.parseVirtualResponseByType(type, body);
        }
        catch (Exception e) {
            JSONObject result = new JSONObject();
            LOG.error("huawei \u89e3\u6790\u865a\u62df\u5546\u54c1\u54cd\u5e94\u7ed3\u679c\u5f02\u5e38 response={}", (Object)body, (Object)e);
            result.put("status", (Object)"fail");
            result.put("errorMessage", (Object)"\u89e3\u6790\u54cd\u5e94\u7ed3\u679c\u5f02\u5e38");
            return result.toJSONString();
        }
    }

    private String parseVirtualResponseByType(String type, String body) {
        if (this.huaweiConfig.getVirtualTypeCredits().equals(type)) {
            return this.parseAddCreditsVirtualResponse(body);
        }
        if (this.huaweiConfig.getVirtualTypeCouponBatch().equals(type)) {
            return this.parseCouponBatchVirtualResponse(body);
        }
        if (this.huaweiConfig.getVirtualTypeCouponCode().equals(type)) {
            return this.parseCouponCodeVirtualResponse(body);
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u8be5\u865a\u62df\u5546\u54c1\u7c7b\u578b\uff1a" + type);
    }

    private String parseCouponCodeVirtualResponse(String body) {
        return this.parseCouponBatchVirtualResponse(body);
    }

    private String parseCouponBatchVirtualResponse(String body) {
        JSONObject result = new JSONObject();
        JSONObject json = JSON.parseObject((String)body);
        String code = (String)StringUtils.defaultIfBlank((CharSequence)json.getString("code"), (CharSequence)"0");
        if (json.getBooleanValue("success") && "0".equals(code)) {
            result.put("status", (Object)"success");
            result.put("supplierBizId", (Object)(System.currentTimeMillis() + RandomStringUtils.randomNumeric((int)6)));
        } else {
            result.put("status", (Object)"fail");
            result.put("errorMessage", (Object)StringUtils.defaultIfBlank((CharSequence)json.getString("errorTip"), (CharSequence)json.getString("msg")));
        }
        return result.toJSONString();
    }

    private String parseAddCreditsVirtualResponse(String body) {
        JSONObject result = new JSONObject();
        JSONObject json = JSON.parseObject((String)body);
        if (json.getBooleanValue("success") && "0".equals(json.getString("code"))) {
            result.put("status", (Object)"success");
            result.put("supplierBizId", (Object)(System.currentTimeMillis() + RandomStringUtils.randomNumeric((int)6)));
        } else {
            result.put("status", (Object)"fail");
            result.put("errorMessage", (Object)json.getString("msg"));
        }
        return result.toJSONString();
    }

    private HttpRequestBase buildVirtualRequestByType(SupplierRequest request, String domain, Map<String, String> params, String type, String value) throws Exception {
        this.markVirtualType(request, type);
        if (this.huaweiConfig.getVirtualTypeCredits().equals(type)) {
            return this.buildAddCreditsVirtualRequest(request, domain, params, value);
        }
        if (this.huaweiConfig.getVirtualTypeCouponBatch().equals(type)) {
            return this.buildCouponBatchVirtualRequest(request, domain, params, value);
        }
        if (this.huaweiConfig.getVirtualTypeCouponCode().equals(type)) {
            return this.buildCouponCodeVirtualRequest(request, domain, params, value);
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u8be5\u865a\u62df\u5546\u54c1\u7c7b\u578b\uff1a" + type);
    }

    private HttpRequestBase buildCouponCodeVirtualRequest(SupplierRequest request, String domain, Map<String, String> params, String value) throws Exception {
        Map<String, String> requestParams = this.buildCommonRequestParams(params);
        requestParams.put("busiCode", value);
        String url = domain + this.huaweiConfig.getReceiveCouponCodeUrl();
        HttpRequestBase result = this.buildJsonRequest(url, requestParams);
        request.setHttpUrl(url);
        request.setAuthParams(requestParams);
        return result;
    }

    private HttpRequestBase buildCouponBatchVirtualRequest(SupplierRequest request, String domain, Map<String, String> params, String value) throws Exception {
        Map<String, String> requestParams = this.buildCommonRequestParams(params);
        String[] arr = StringUtils.split((String)value, (char)',');
        if (arr.length != 2) {
            throw new IllegalStateException("\u4f18\u60e0\u5238\u6279\u6b21\u503c\u914d\u7f6e\u6709\u8bef");
        }
        requestParams.put("activityCode", arr[0].trim());
        requestParams.put("batchCode", arr[1].trim());
        requestParams.put("receiveChannel", "1");
        String url = domain + this.huaweiConfig.getReceiveCouponBatchUrl();
        HttpRequestBase result = this.buildJsonRequest(url, requestParams);
        request.setHttpUrl(url);
        request.setAuthParams(requestParams);
        return result;
    }

    private Map<String, String> buildCommonRequestParams(Map<String, String> params) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("appId", this.huaweiConfig.getHuaweiAppId());
        result.put("openId", params.get("uid"));
        result.put("portal", "72");
        result.put("lang", "zh-CN");
        result.put("country", "CN");
        return result;
    }

    private void markVirtualType(SupplierRequest request, String type) {
        Map<String, String> params = request.getParams();
        if (params == null) {
            params = new HashMap<String, String>();
            request.setParams(params);
        }
        params.put(VIRTUAL_TYPE_KEY, type);
    }

    private Pair<String, String> parseThirdCode(String thirdCode) {
        String[] arr = StringUtils.split((String)thirdCode, (char)'-');
        if (arr.length != 2) {
            throw new IllegalStateException("\u865a\u62df\u5546\u54c1\u5546\u5bb6\u7f16\u7801\u683c\u5f0f\u9519\u8bef");
        }
        return Pair.of((Object)arr[0].trim().toUpperCase(), (Object)arr[1].trim());
    }

    private HttpRequestBase buildAddCreditsVirtualRequest(SupplierRequest request, String domain, Map<String, String> params, String value) throws Exception {
        params.put("credits", value);
        Map<String, String> requestParams = this.buildCommonCreditsParams(params, this.huaweiConfig.getAddCreditsActCode());
        String url = domain + this.huaweiConfig.getAddCreditsPath();
        HttpRequestBase result = this.buildJsonRequest(url, requestParams);
        request.setHttpUrl(url);
        request.setAuthParams(requestParams);
        return result;
    }

    private Map<String, String> buildAddCreditsParams(String httpUrl, AddCreditsParams addCreditsParams) throws Exception {
        if (!Objects.isNull(addCreditsParams) && SOURCE_TYPE.contains((Object)addCreditsParams.getType())) {
            Map<String, String> getBuildAddCreditsParams = this.buildCommonCreditsParams(UrlUtils.extractUrlParamsFromUrl(httpUrl), this.huaweiConfig.getSignAddCreditsActCode());
            LOG.info("huawei \u589e\u52a0\u79ef\u5206\u8bf7\u6c42,\u8bf7\u6c42\u7c7b\u578bSOURCE_TYPE={},httpUrl={},request={}", new Object[]{addCreditsParams.getType(), httpUrl, JSONObject.toJSONString(getBuildAddCreditsParams)});
            return getBuildAddCreditsParams;
        }
        LOG.info("huawei \u589e\u52a0\u79ef\u5206\u8bf7\u6c42,httpUrl={}", (Object)httpUrl);
        return this.buildCommonCreditsParams(UrlUtils.extractUrlParamsFromUrl(httpUrl), this.huaweiConfig.getAddCreditsActCode());
    }

    private Map<String, String> buildConsumeCreditsParams(String httpUrl) throws Exception {
        return this.buildCommonCreditsParams(UrlUtils.extractUrlParamsFromUrl(httpUrl), this.huaweiConfig.getConsumeCreditsActCode());
    }

    private Map<String, String> buildCommonCreditsParams(Map<String, String> params, String actCode) throws Exception {
        Map<String, String> result = this.buildCommonRequestParams(params);
        String transId = this.generateTransId();
        result.put("transId", transId);
        result.put("pointValue", params.get("credits"));
        result.put("serviceUnit", this.huaweiConfig.getServiceUnit());
        result.put("actCode", actCode);
        result.put("timeStamp", params.get("timestamp"));
        result.put("actTime", this.generateActTime());
        Date startDate = DateUtils.getSecondDate((String)"2022-04-01 00:00:00");
        Date now = new Date();
        if (now.compareTo(startDate) > 0 && !StringUtils.equals((CharSequence)actCode, (CharSequence)this.huaweiConfig.getConsumeCreditsActCode())) {
            result.put("expireDate", this.generateExpireDate());
        }
        TreeMap<String, String> signParams = new TreeMap<String, String>();
        signParams.put("transId", transId);
        signParams.put("appId", this.huaweiConfig.getHuaweiAppId());
        signParams.put("openId", params.get("uid"));
        signParams.put("pointValue", params.get("credits"));
        signParams.put("serviceUnit", this.huaweiConfig.getServiceUnit());
        signParams.put("actCode", actCode);
        signParams.put("timeStamp", params.get("timestamp"));
        result.put("sign", this.sign(signParams));
        return result;
    }

    private HttpRequestBase buildJsonRequest(String url, Map<String, String> params) throws Exception {
        HttpPost post = new HttpPost(url);
        post.setHeaders(this.createCustomHeaders());
        post.setEntity((HttpEntity)new StringEntity(JSON.toJSONString(params), ContentType.APPLICATION_JSON));
        return post;
    }

    private String sign(TreeMap<String, String> params) throws Exception {
        String signStr = UrlUtils2.buildUrlParams(params);
        LOG.info("huawei \u7b7e\u540d\u5b57\u7b26\u4e32 {}", (Object)signStr);
        return SignUtils.sign(signStr, this.huaweiConfig.getPrivateKeyInstance());
    }

    public Map<String, String> headerMap(Header[] headers) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Header header : headers) {
            map.put(header.getName(), header.getValue());
        }
        return map;
    }

    private Header[] createCustomHeaders() throws Exception {
        Header[] headers = new Header[4];
        headers[0] = new BasicHeader("VmallDeviceType", this.huaweiConfig.getVmallDeviceType());
        headers[1] = new BasicHeader("VmallDeviceAccount", this.huaweiConfig.getVmallDeviceAccount());
        String vmallTimeStamp = this.generateVmallTimeStamp();
        headers[2] = new BasicHeader("VmallDevicePassword", this.getVmallDevicePassword(vmallTimeStamp));
        headers[3] = new BasicHeader("VmallTimeStamp", vmallTimeStamp);
        return headers;
    }

    private String getVmallDevicePassword(String vmallTimeStamp) throws Exception {
        String data = StringUtils.join((Object[])new String[]{this.huaweiConfig.getVmallDevicePassword(), Base64.toBase64String((byte[])this.huaweiConfig.getVmallDeviceType().getBytes(StandardCharsets.UTF_8)), vmallTimeStamp});
        return SignUtils.hmacSHA256(data, SignUtils.sha256(this.huaweiConfig.getEncryptSecret()));
    }

    private String generateVmallTimeStamp() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ZZZ").format(new Date());
    }

    private String generateActTime() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZZZ").format(new Date());
    }

    private String generateTransId() {
        String formatTime = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
        return this.huaweiConfig.getServiceUnit() + formatTime + RandomStringUtils.randomNumeric((int)4);
    }

    private String generateExpireDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 1);
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZZZ").format(calendar.getTime());
    }

    public static void main(String[] args) {
        System.out.println(new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()));
    }
}

