/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.config.MengJieConfig;
import cn.com.duiba.credits.sdk.AssembleTool;
import cn.com.duiba.credits.sdk.CreditConsumeParams;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSONObject;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MengJieCreditsApi {
    @Autowired
    private MengJieConfig mengJieConfig;
    private static Logger log = LoggerFactory.getLogger(MengJieCreditsApi.class);

    public Boolean isMengJie(Long appId) {
        List appIds = Arrays.stream(this.mengJieConfig.getAppIds().split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        return appIds.contains(appId);
    }

    public static byte[] encryptMD5(byte[] data) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(data);
        return md5.digest();
    }

    public static String toHexValue(byte[] messageDigest) {
        if (messageDigest == null) {
            return "";
        }
        StringBuilder hexValue = new StringBuilder();
        for (byte aMessageDigest : messageDigest) {
            int val = 0xFF & aMessageDigest;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    public SubCreditsMsgWrapper getMogujieRequestCredits(SubCreditsMsgWrapper request) {
        try {
            CreditConsumeParams creditConsumeParams = request.getSubCreditsMsg().getCreditConsumeParams();
            String src = "baison";
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("key", "baison");
            map.put("timestamp", String.valueOf(System.currentTimeMillis()));
            map.put("api_url", "crm/integral/add");
            map.put("source", "24");
            map.put("vip_code", creditConsumeParams.getUid());
            map.put("integral", "-" + creditConsumeParams.getCredits().toString());
            map.put("v", "2");
            map.put("shop_code", "ZB");
            map.put("relation_code", creditConsumeParams.getOrderNum());
            map.put("remark", creditConsumeParams.getDescription());
            Set sets = map.keySet();
            ArrayList keys = new ArrayList(sets);
            Collections.sort(keys);
            for (String key : keys) {
                src = src + key + (String)map.get(key);
            }
            src = src + "123456";
            String sign = "";
            try {
                sign = MengJieCreditsApi.toHexValue(MengJieCreditsApi.encryptMD5(src.getBytes()));
                sign = MengJieCreditsApi.toHexValue(MengJieCreditsApi.encryptMD5(sign.getBytes()));
                sign = MengJieCreditsApi.toHexValue(MengJieCreditsApi.encryptMD5(sign.getBytes()));
            }
            catch (Exception e) {
                log.error("\u68a6\u6d01\u6263\u79ef\u5206\u7b7e\u540d\u52a0\u5bc6\u9519\u8bef", (Throwable)e);
            }
            map.put("sign", sign);
            String head = this.mengJieConfig.getMengjieUrlHead() + "app_act=crm/integral/add";
            String url = AssembleTool.assembleUrl((String)head, map);
            request.setHttpUrl(url);
            request.getSubCreditsMsg().setHttpType(1);
            return request;
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u68a6\u6d01\u6263\u79ef\u5206\u63a5\u53e3\u51fa\u9519", (Throwable)e);
            return request;
        }
    }

    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request) throws BizException {
        try {
            Map originAuthParams = request.getAuthParams();
            String src = "baison";
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("key", "baison");
            map.put("timestamp", String.valueOf(System.currentTimeMillis()));
            map.put("api_url", "crm/integral/add");
            map.put("source", "24");
            map.put("vip_code", (String)originAuthParams.get("uid"));
            map.put("integral", (String)originAuthParams.get("credits"));
            map.put("v", "2");
            map.put("shop_code", "ZB");
            map.put("relation_code", (String)originAuthParams.get("orderNum"));
            map.put("remark", (String)originAuthParams.get("description"));
            Set sets = map.keySet();
            ArrayList keys = new ArrayList(sets);
            Collections.sort(keys);
            for (String key : keys) {
                src = src + key + (String)map.get(key);
            }
            src = src + "123456";
            String sign = "";
            try {
                sign = MengJieCreditsApi.toHexValue(MengJieCreditsApi.encryptMD5(src.getBytes()));
                sign = MengJieCreditsApi.toHexValue(MengJieCreditsApi.encryptMD5(sign.getBytes()));
                sign = MengJieCreditsApi.toHexValue(MengJieCreditsApi.encryptMD5(sign.getBytes()));
            }
            catch (Exception e) {
                log.error("\u68a6\u6d01\u52a0\u79ef\u5206\u7b7e\u540d\u52a0\u5bc6\u9519\u8bef", (Throwable)e);
            }
            map.put("sign", sign);
            String head = this.mengJieConfig.getMengjieUrlHead() + "app_act=crm/integral/add";
            String url = AssembleTool.assembleUrl((String)head, map);
            request.setHttpUrl(url);
            request.setHttpType("get");
            return request;
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u68a6\u6d01\u52a0\u79ef\u5206\u63a5\u53e3\u51fa\u9519", (Throwable)e);
            return request;
        }
    }

    public String parseCreditsRsp(String body) {
        JSONObject responseBody;
        try {
            responseBody = JSONObject.parseObject((String)body);
        }
        catch (Exception e) {
            log.error("JSON.parseObject:", (Throwable)e);
            return body;
        }
        String status = responseBody.getString("status");
        String message = responseBody.getString("message");
        String successStatus = "1";
        String successMessage = "\u66f4\u65b0\u6210\u529f";
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        if (Objects.equals(status, successStatus) && Objects.equals(message, successMessage)) {
            duibaDoc.put("status", "ok");
            duibaDoc.put("bizId", "");
        } else {
            duibaDoc.put("status", "fail");
            if (message != null) {
                duibaDoc.put("errorMessage", message);
            }
        }
        duibaDoc.put("bizId", String.valueOf(System.currentTimeMillis()));
        return JsonTool.objectToJson(duibaDoc);
    }
}

