/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TaojinbiApi {
    private static final String SUB_CREDITS_METHOD = "taobao.coin.buyer.consume";
    private static final Logger log = LoggerFactory.getLogger(TaojinbiApi.class);
    @Value(value="${taobao.app.appkey}")
    private String taobaoAppkey;
    @Value(value="${taobao.app.secret}")
    private String taobaoAppSecret;

    public CreditsMessage getCreditsMessage(CreditsMessage request) {
        Map params = request.getParams();
        HashMap<String, String> authParams = new HashMap<String, String>();
        authParams.put("method", SUB_CREDITS_METHOD);
        authParams.put("app_key", this.taobaoAppkey);
        authParams.put("sign_method", "md5");
        authParams.put("session", (String)params.get("accessKey"));
        authParams.put("timestamp", DateUtils.getSecondStr((Date)new Date()));
        authParams.put("format", "json");
        authParams.put("v", "2.0");
        authParams.put("buyer_nick", (String)params.get("mixUserNick"));
        authParams.put("amount", (String)params.get("credits"));
        authParams.put("token", (String)params.get("token"));
        authParams.put("sign", this.sign(authParams));
        request.setAuthParams(authParams);
        request.setHttpType("post");
        String url = request.getHttpUrl().substring(0, request.getHttpUrl().indexOf(63));
        request.setHttpUrl(url);
        return request;
    }

    public SubCreditsMsgWrapper getCreditsMessage(SubCreditsMsgWrapper request) {
        Map params = request.getSubCreditsMsg().getParams();
        HashMap<String, String> authParams = new HashMap<String, String>();
        authParams.put("method", SUB_CREDITS_METHOD);
        authParams.put("app_key", this.taobaoAppkey);
        authParams.put("sign_method", "md5");
        authParams.put("session", (String)params.get("accessKey"));
        authParams.put("timestamp", DateUtils.getSecondStr((Date)new Date()));
        authParams.put("format", "json");
        authParams.put("v", "2.0");
        authParams.put("buyer_nick", (String)params.get("mixUserNick"));
        authParams.put("amount", (String)params.get("credits"));
        authParams.put("token", (String)params.get("token"));
        authParams.put("sign", this.sign(authParams));
        request.getSubCreditsMsg().setAuthParams(authParams);
        request.getSubCreditsMsg().setHttpType(2);
        String url = request.getHttpUrl().substring(0, request.getHttpUrl().indexOf(63));
        request.setHttpUrl(url);
        return request;
    }

    public String parseCreditsRsp(String msg2) {
        String totalAmount;
        String traceId;
        JSONObject jsonObject;
        try {
            jsonObject = JSONObject.parseObject((String)msg2);
        }
        catch (Exception e) {
            log.error("JSON.parseObject:", (Throwable)e);
            return msg2;
        }
        JSONObject allJson = JsonTool.getAllJson(jsonObject);
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        boolean success = false;
        Long subCredits = allJson.getLong("succ_amount");
        if (subCredits != null) {
            success = true;
        }
        duibaDoc.put("status", success ? "ok" : "fail");
        String code = allJson.getString("code");
        String errorMessage = null;
        if (code != null) {
            String errmsg = allJson.getString("msg");
            String subCode = allJson.getString("sub_code");
            String errSubMsg = allJson.getString("sub_msg");
            errorMessage = code + '|' + errmsg + '|' + subCode + '|' + errSubMsg;
        }
        if (errorMessage != null) {
            duibaDoc.put("errorMessage", errorMessage);
        }
        if ((traceId = allJson.getString("trace_id")) != null) {
            duibaDoc.put("bizId", traceId);
        }
        if ((totalAmount = allJson.getString("total_amount")) != null) {
            duibaDoc.put("credits", totalAmount);
        }
        return JsonTool.objectToJson(duibaDoc);
    }

    private String sign(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder string = new StringBuilder();
        string.append(this.taobaoAppSecret);
        for (String key : keys) {
            string.append(key).append(params.get(key));
        }
        string.append(this.taobaoAppSecret);
        return DigestUtils.md5Hex((String)string.toString()).toUpperCase();
    }
}

