/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.consumer.center.api.dto.ConsumerExtraDto;
import cn.com.duiba.consumer.center.api.remoteservice.RemoteConsumerExtraService;
import cn.com.duiba.vo.union.UnionRelationInfoVO;
import cn.hutool.core.lang.Pair;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnionCommonApi {
    @Autowired
    private RemoteConsumerExtraService remoteConsumerExtraService;

    public Pair<String, String> getUserOpenIdAndMobile(Long consumerId, String unionAppId) {
        ConsumerExtraDto consumerExtra = (ConsumerExtraDto)this.remoteConsumerExtraService.findByConsumerId(consumerId).getResult();
        String mobile = "";
        String openId = "";
        if (Objects.nonNull(consumerExtra) && StringUtils.isNotBlank((CharSequence)consumerExtra.getJson())) {
            UnionRelationInfoVO unionRelationInfoVO;
            JSONObject extra = JSON.parseObject((String)consumerExtra.getJson());
            mobile = extra.getString("mobile");
            JSONArray jsonExtraArray = extra.getJSONArray("unionLoginAppIdOpenIds");
            if (CollectionUtils.isNotEmpty((Collection)jsonExtraArray) && (unionRelationInfoVO = (UnionRelationInfoVO)jsonExtraArray.toJavaList(UnionRelationInfoVO.class).stream().filter(item -> unionAppId.equals(item.getAppId())).findFirst().orElse(null)) != null) {
                openId = unionRelationInfoVO.getOpenId();
            }
        }
        return Pair.of((Object)openId, (Object)mobile);
    }
}

