/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.biz.credits.UnionCommonApi;
import cn.com.duiba.constant.UnionPayConstants;
import cn.com.duiba.constant.UnionRedConstant;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.DES3Tool;
import cn.com.duiba.tool.UnionPayBankUtil;
import cn.com.duiba.vo.union.UnionRedConfig;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Pair;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnionRedApi {
    private static final String LOG_NAME = "\u94f6\u8054\u901a\u7528\u7ea2\u5305\u865a\u62df\u5546\u54c1";
    private static final Logger LOGGER = LoggerFactory.getLogger(UnionRedApi.class);
    @Autowired
    private UnionRedConstant unionRedConstant;
    @Autowired
    private UnionPayConstants unionPayConstants;
    @Autowired
    private UnionCommonApi unionCommonApi;

    public UnionRedConfig getUnionRedConfig(String goodsParams, String duibaAppId) {
        List unionRedConfigs = JSON.parseArray((String)this.unionRedConstant.getMiniAppConfigs(), UnionRedConfig.class);
        List unionRedMiniConfig = unionRedConfigs.stream().filter(item -> duibaAppId.equals(item.getAppId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(unionRedMiniConfig)) {
            return null;
        }
        Pair<String, String> businessTypeAndPoint = this.getBusinessTypeAndPoint(goodsParams);
        String businessType = (String)businessTypeAndPoint.getKey();
        UnionRedConfig unionBusConfig = unionRedMiniConfig.stream().filter(item -> businessType.equals(item.getBusinessType())).findFirst().orElse(null);
        if (unionBusConfig == null) {
            return null;
        }
        return unionBusConfig;
    }

    private Pair<String, String> getBusinessTypeAndPoint(String params) {
        String[] goodsNum = params.split("_");
        if (goodsNum.length < 3) {
            throw new ThirdpatyException("\u94f6\u8054\u7ea2\u5305\u5546\u54c1\u7f16\u7801\u9519\u8bef");
        }
        return Pair.of((Object)goodsNum[1], (Object)goodsNum[2]);
    }

    public HttpRequestBase buildUnionRedRequest(Map<String, String> authParamMap, SupplierRequest request, UnionRedConfig unionRedConfig) {
        String miniAppId = unionRedConfig.getMiniAppId();
        Pair<String, String> userOpenIdAndMobile = this.unionCommonApi.getUserOpenIdAndMobile(Long.valueOf(request.getConsumerId()), miniAppId);
        String openId = (String)userOpenIdAndMobile.getKey();
        String mobile = (String)userOpenIdAndMobile.getValue();
        if (StringUtils.isBlank((CharSequence)openId) && StringUtils.isBlank((CharSequence)mobile)) {
            LOGGER.error("{}, appId={}, consumerId={}, \u7528\u6237\u53c2\u6570\u7f3a\u5931", new Object[]{LOG_NAME, request.getAppId(), request.getConsumerId()});
            throw new RuntimeException("\u7528\u6237\u4fe1\u606f\u53c2\u6570\u7f3a\u5931");
        }
        boolean sendByOpenId = StringUtils.isBlank((CharSequence)unionRedConfig.getSendUserIdType()) || "openId".equals(unionRedConfig.getSendUserIdType());
        String goodsNum = authParamMap.get("params");
        Pair<String, String> businessTypeAndPoint = this.getBusinessTypeAndPoint(goodsNum);
        String pointAt = (String)businessTypeAndPoint.getValue();
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("appId", miniAppId);
        requestParams.put("transSeqId", authParamMap.get("orderNum"));
        requestParams.put("transTs", DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
        requestParams.put("nonceStr", UnionPayBankUtil.createNonceStr());
        requestParams.put("insAcctId", unionRedConfig.getInsAcctId());
        requestParams.put("pointId", unionRedConfig.getPointId());
        requestParams.put("pointAt", pointAt);
        requestParams.put("transDigest", unionRedConfig.getTransDigest());
        requestParams.put("timestamp", Long.toString(System.currentTimeMillis() / 1000L));
        if (sendByOpenId) {
            requestParams.put("openId", openId);
            requestParams.put("acctEntityTp", "03");
        } else {
            requestParams.put("mobile", mobile);
            requestParams.put("acctEntityTp", "01");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("campaignId", (Object)unionRedConfig.getCampaignId());
        jsonObject.put("campaignName", (Object)unionRedConfig.getCampaignName());
        requestParams.put("busiInfo", jsonObject.toJSONString());
        if (StringUtils.isNotBlank((CharSequence)unionRedConfig.getRemark())) {
            requestParams.put("remark", unionRedConfig.getRemark());
        }
        if (StringUtils.isNotBlank((CharSequence)unionRedConfig.getValidBeginTs()) && StringUtils.isNotBlank((CharSequence)unionRedConfig.getValidEndTs())) {
            requestParams.put("validBeginTs", unionRedConfig.getValidBeginTs());
            requestParams.put("validEndTs", unionRedConfig.getValidEndTs());
        }
        requestParams.put("signature", UnionPayBankUtil.sign(requestParams, this.unionPayConstants.getSignPrivateKey(miniAppId)));
        LOGGER.info("{}, orderId={}, \u8bf7\u6c42\u53c2\u6570={}", new Object[]{LOG_NAME, request.getOrderId(), JSON.toJSONString(requestParams)});
        try {
            if (!sendByOpenId) {
                requestParams.put("mobile", DES3Tool.getEncryptedValue(mobile, this.unionPayConstants.getSymmetricKey(miniAppId)));
            }
        }
        catch (Exception e) {
            LOGGER.warn("{}, \u865a\u62df\u5546\u54c1\u53c2\u6570\u52a0\u5bc6\u5931\u8d25, orderId={}", new Object[]{LOG_NAME, request.getOrderId(), e});
            throw new ThirdpatyException("\u94f6\u8054\u901a\u7528\u7ea2\u5305\u865a\u62df\u5546\u54c1, \u52a0\u5bc6\u5931\u8d25");
        }
        HttpPost post = new HttpPost(this.unionRedConstant.getRedSendUrl());
        post.setEntity((HttpEntity)new StringEntity(JSON.toJSONString(requestParams), ContentType.APPLICATION_JSON));
        return post;
    }

    public String buildUnionRedResponse(SupplierRequest request, String body) {
        if (StringUtils.isBlank((CharSequence)body)) {
            throw new ThirdpatyException("\u94f6\u8054\u7ea2\u5305\uff0c\u865a\u62df\u5546\u54c1\u5b9a\u5236\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        LOGGER.info("{}, \u94f6\u8054\u7ea2\u5305\u54cd\u5e94\u53c2\u6570, orderId={}, body={}", new Object[]{LOG_NAME, request.getOrderId(), body});
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            JSONObject jsonObject = JSON.parseObject((String)body);
            map.put("status", Objects.equals("00", jsonObject.getString("resp")) ? "success" : "fail");
            map.put("errorMessage", StringEscapeUtils.unescapeHtml4((String)jsonObject.getString("msg")));
        }
        catch (Exception e) {
            LOGGER.error("{}\uff0c\u865a\u62df\u5546\u54c1\u5b9a\u5236\uff0c\u7ed3\u679c\u89e3\u6790\u9519\u8bef:{}", new Object[]{LOG_NAME, body, e});
            map.put("status", "fail");
            map.put("errorMessage", "\u865a\u62df\u5546\u54c1\u5145\u503c\u63a5\u53e3\u54cd\u5e94\u89e3\u6790\u9519\u8bef");
        }
        return JSON.toJSONString(map);
    }
}

