/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.XieChengConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XieChengApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(XieChengApi.class);
    private static final String CHARACTER_ENCODE = "UTF-8";
    private static final String APPLICATION_JSON = "application/json";
    private static final String TRANSFER_SPLIT = "_duiba_";
    @Autowired
    private XieChengConfig xieChengConfig;

    public boolean isXieChengAppid(Long appId) {
        String xiechengAppId = this.xieChengConfig.getAppId();
        return StringUtils.isNotBlank((CharSequence)xiechengAppId) && xiechengAppId.equals(String.valueOf(appId));
    }

    public CreditsMessage getSubCreditsMessage(CreditsMessage request) throws BizException {
        Map originAuthParams = request.getAuthParams();
        String requestNo = (String)originAuthParams.get("orderNum");
        Map<String, String> authParams = this.buildAuthParams(requestNo, originAuthParams);
        request.setAuthParams(authParams);
        request.setHttpType("post");
        return request;
    }

    public HttpRequestBase getSubCreditsHttpRequestBase(SubCreditsMsgWrapper subCreditsMsgWrapper) {
        Map params = subCreditsMsgWrapper.getSubCreditsMsg().getAuthParams();
        String creditsConsumeRequestUrl = subCreditsMsgWrapper.getSubCreditsMsg().getCreditsConsumeRequestUrl();
        String paramsJsonStr = JSON.toJSONString((Object)params);
        HttpPost httpPost = new HttpPost(creditsConsumeRequestUrl);
        StringEntity stringEntity = new StringEntity(paramsJsonStr, CHARACTER_ENCODE);
        stringEntity.setContentEncoding(CHARACTER_ENCODE);
        stringEntity.setContentType(APPLICATION_JSON);
        httpPost.setEntity((HttpEntity)stringEntity);
        subCreditsMsgWrapper.setHttpUrl(creditsConsumeRequestUrl);
        LOGGER.info("\u643a\u7a0b\u5b9a\u5236\u6263\u79ef\u5206\u8bf7\u6c42\uff0crequestUrl\uff1a{}\uff0cparams\uff1a{}", (Object)creditsConsumeRequestUrl, (Object)paramsJsonStr);
        return httpPost;
    }

    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper subCreditsMsgWrapper) throws BizException {
        SubCreditsMsgDto msg2 = subCreditsMsgWrapper.getSubCreditsMsg();
        Map originAuthParams = msg2.getAuthParams();
        String requestNo = (String)originAuthParams.get("orderNum");
        Map<String, String> authParams = this.buildAuthParams(requestNo, originAuthParams);
        msg2.setAuthParams(authParams);
        msg2.setHttpType(2);
        return subCreditsMsgWrapper;
    }

    private Map<String, String> buildAuthParams(String requestNo, Map<String, String> originAuthParams) {
        String[] transfers = originAuthParams.get("transfer").split(TRANSFER_SPLIT);
        String accessToken = transfers[1];
        String openId = originAuthParams.get("uid");
        String pointNum = originAuthParams.get("credits");
        String channelCode = transfers[0];
        String timestamp = String.valueOf(System.currentTimeMillis());
        String signVal = accessToken + channelCode + openId + pointNum + requestNo + timestamp;
        HashMap<String, String> authParams = new HashMap<String, String>(7);
        authParams.put("openId", openId);
        authParams.put("accessToken", accessToken);
        authParams.put("pointNum", pointNum);
        authParams.put("requestNo", requestNo);
        authParams.put("channelCode", channelCode);
        authParams.put("timestamp", timestamp);
        if (transfers.length >= 3) {
            authParams.put("scene", transfers[2]);
            LOGGER.info("\u643a\u7a0b\u5b9a\u5236\u52a0\u79ef\u5206\u8bf7\u6c42\uff0c\u573a\u666f\u503c\uff1a{}\uff0cparams\uff1a{}", (Object)transfers[2], (Object)JSON.toJSONString(authParams));
        }
        try {
            authParams.put("sign", HmacUtils.hmacSha1Hex((String)this.xieChengConfig.getSignKey(), (String)signVal));
        }
        catch (Exception e) {
            LOGGER.warn("\u643a\u7a0b sign \u7b7e\u540d\u5931\u8d25 params = {}", (Object)JSON.toJSONString(authParams), (Object)e);
        }
        return authParams;
    }

    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request) {
        Map params = request.getAuthParams();
        String bizId = request.getBizId();
        Map<String, String> authParams = this.buildAuthParams(bizId, params);
        request.setAuthParams(authParams);
        request.setHttpType("post");
        return request;
    }

    public HttpRequestBase getAddCreditsHttpRequestBase(CreditsMessageDto message) {
        Map params = message.getAuthParams();
        String httpUrl = message.getHttpUrl();
        String host = httpUrl.substring(0, httpUrl.indexOf(63));
        String paramsJsonStr = JSONObject.toJSONString((Object)params);
        HttpPost httpPost = new HttpPost(host);
        StringEntity stringEntity = new StringEntity(paramsJsonStr, CHARACTER_ENCODE);
        stringEntity.setContentEncoding(CHARACTER_ENCODE);
        stringEntity.setContentType(APPLICATION_JSON);
        httpPost.setEntity((HttpEntity)stringEntity);
        message.setHttpUrl(host);
        LOGGER.info("\u643a\u7a0b\u5b9a\u5236\u52a0\u79ef\u5206\u8bf7\u6c42\uff0crequestUrl\uff1a{}\uff0cparams\uff1a{}", (Object)host, (Object)paramsJsonStr);
        return httpPost;
    }

    public String getResponseCredits(String body, Map<String, String> authParams) {
        try {
            JSONObject jsonBody = JSON.parseObject((String)body);
            HashMap<String, String> duibaDoc = new HashMap<String, String>();
            String msg2 = jsonBody.getString("msg");
            if ("SUCCESS".equals(msg2)) {
                duibaDoc.put("status", "ok");
            } else {
                LOGGER.warn("\u643a\u7a0b\u5b9a\u5236\u79ef\u5206\u52a0\u51cf\u54cd\u5e94\u5f02\u5e38 body={}\uff0c\u8bf7\u6c42\u53c2\u6570={}", (Object)body, (Object)JSON.toJSONString(authParams));
                duibaDoc.put("status", "fail");
            }
            duibaDoc.put("errorMessage", msg2);
            duibaDoc.put("bizId", authParams.get("requestNo"));
            duibaDoc.put("credits", authParams.get("pointNum"));
            return JsonTool.objectToJson(duibaDoc);
        }
        catch (Exception e) {
            LOGGER.error("\u643a\u7a0b\u5b9a\u5236\u79ef\u5206\u52a0\u51cf \u54cd\u5e94\u5f02\u5e38 body={},error={}", (Object)body, (Object)e.getMessage());
            return body;
        }
    }
}

