/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.constant.yumin.YmBankConfig;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class YuMinBankApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(YuMinBankApi.class);
    @Resource
    private YmBankConfig ymBankConfig;

    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper subCreditsMsgWrapper) {
        try {
            SubCreditsMsgDto subCreditsMsg = subCreditsMsgWrapper.getSubCreditsMsg();
            Map params = subCreditsMsg.getParams();
            if (params == null || params.isEmpty()) {
                return subCreditsMsgWrapper;
            }
            Map map = subCreditsMsg.getCreditConsumeParams().toRequestMap(subCreditsMsg.getAppSecret());
            Map<String, String> newAuth = this.addParamsAndReSign(subCreditsMsg.getAppSecret(), map, params);
            LOGGER.info("\u6c5f\u897f\u88d5\u6c11\u94f6\u884c\u6263\u79ef\u5206\u8bf7\u6c42\u53c2\u6570={}", (Object)JSONObject.toJSONString(newAuth));
            subCreditsMsgWrapper.setHttpUrl(AssembleTool.assembleUrl(this.getPureUrl(subCreditsMsgWrapper.getHttpUrl()), newAuth));
            LOGGER.info("\u6c5f\u897f\u88d5\u6c11\u94f6\u884c\u6263\u79ef\u5206\u8bf7\u6c42url={}", (Object)subCreditsMsgWrapper.getHttpUrl());
            return subCreditsMsgWrapper;
        }
        catch (Exception e) {
            LOGGER.info("YuMinBankApi call getSubCreditsMessage error , subCreditsMsgWrapper = {}", (Object)JSONObject.toJSONString((Object)subCreditsMsgWrapper), (Object)e);
            return subCreditsMsgWrapper;
        }
    }

    private Map<String, String> addParamsAndReSign(String appSecret, Map<String, String> authParams, Map<String, String> params) {
        authParams.remove("sign");
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (!this.ymBankConfig.getParamsKeys().contains(entry.getKey())) continue;
            authParams.put(entry.getKey(), entry.getValue());
        }
        authParams.put("appSecret", appSecret);
        authParams.put("sign", SignTool.sign(authParams));
        authParams.remove("appSecret");
        return authParams;
    }

    private String getPureUrl(String urlWithParams) {
        return urlWithParams.substring(0, urlWithParams.indexOf(63));
    }

    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto creditsMessageDto) {
        try {
            Map params = creditsMessageDto.getParams();
            if (MapUtils.isEmpty((Map)params)) {
                return creditsMessageDto;
            }
            String appSecret = (String)params.get("appSecret");
            params.remove("appSecret");
            Map map = creditsMessageDto.getAuthParams();
            Map<String, String> newAuth = this.addParamsAndReSign(appSecret, map, params);
            LOGGER.info("\u6c5f\u897f\u88d5\u6c11\u94f6\u884c\u52a0\u79ef\u5206\u8bf7\u6c42\u53c2\u6570={}", (Object)JSONObject.toJSONString(newAuth));
            creditsMessageDto.setHttpUrl(AssembleTool.assembleUrl(this.getPureUrl(creditsMessageDto.getHttpUrl()), newAuth));
            LOGGER.info("\u6c5f\u897f\u88d5\u6c11\u94f6\u884c\u52a0\u79ef\u5206\u8bf7\u6c42\uff0cparam={}", (Object)JSON.toJSONString((Object)creditsMessageDto));
            return creditsMessageDto;
        }
        catch (Exception e) {
            LOGGER.info("\u6c5f\u897f\u88d5\u6c11\u94f6\u884c\u52a0\u79ef\u5206\u5f02\u5e38\uff0cparams:{}", (Object)JSON.toJSONString((Object)creditsMessageDto), (Object)e);
            return creditsMessageDto;
        }
    }

    public SupplierRequest getVirtualExchange(SupplierRequest supplierRequest) {
        try {
            Map<String, String> params = supplierRequest.getParams();
            if (MapUtils.isEmpty(params)) {
                return supplierRequest;
            }
            String appSecret = params.get("appSecret");
            Map<String, String> map = supplierRequest.getAuthParams();
            Map<String, String> newAuth = this.addParamsAndReSign(appSecret, map, params);
            LOGGER.info("\u6c5f\u897f\u88d5\u6c11\u94f6\u884c\u865a\u62df\u5151\u6362\u8bf7\u6c42\u53c2\u6570={}", (Object)JSONObject.toJSONString(newAuth));
            supplierRequest.setHttpUrl(AssembleTool.assembleUrl(this.getPureUrl(supplierRequest.getHttpUrl()), newAuth));
            LOGGER.info("\u6c5f\u897f\u88d5\u6c11\u94f6\u884c\u865a\u62df\u5151\u6362\u8bf7\u6c42, param={}", (Object)JSON.toJSONString((Object)supplierRequest));
            return supplierRequest;
        }
        catch (Exception e) {
            LOGGER.info("\u6c5f\u897f\u88d5\u6c11\u94f6\u884c\u865a\u62df\u5151\u6362\u5f02\u5e38\uff0cparams:{}", (Object)JSON.toJSONString((Object)supplierRequest), (Object)e);
            return supplierRequest;
        }
    }
}

