/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.nongzonghang;

import cn.com.duiba.constant.nongzonghang.FuLuConfig;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.domain.SupplierResponse;
import cn.com.duiba.domain.VirtualSupplierProcessingOrderLogEntity;
import cn.com.duiba.dto.fulu.FuLuBaseReq;
import cn.com.duiba.dto.fulu.FuLuBaseResp;
import cn.com.duiba.dto.fulu.req.OrderDirectAddReq;
import cn.com.duiba.dto.fulu.resp.OrderDirectAddResp;
import cn.com.duiba.dto.virtualsupplierprocess.MqInfo;
import cn.com.duiba.service.ThreadPoolService;
import cn.com.duiba.service.virtualsupplierprocess.VirtualSupplierProcessOrderService;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.fulu.FuLuUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FuLuApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(FuLuApi.class);
    private static Set<Integer> UNUSUAL_CODE = Sets.newHashSet((Object[])new Integer[]{4008, 4009, 4010, 4012, 5000});
    @Autowired
    private FuLuConfig fuluConfig;
    @Autowired
    private VirtualSupplierProcessOrderService virtualSupplierProcessOrderService;
    @Autowired
    private ThreadPoolService threadPoolService;

    public Boolean isFuLu4NongZongHang(SupplierRequest message) {
        Map<Long, String> map = this.fuluConfig.getAppItemProductMap();
        if (MapUtils.isEmpty(map)) {
            return false;
        }
        String appItemIdStr = message.getParams().get("appItemId");
        if (StringUtils.isBlank((String)appItemIdStr)) {
            return false;
        }
        Long appItemId = Long.valueOf(appItemIdStr);
        if (!map.keySet().contains(appItemId)) {
            return false;
        }
        return true;
    }

    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        Long appItemId = Long.valueOf(request.getParams().get("appItemId"));
        String productId = this.fuluConfig.getAppItemProductMap().get(appItemId);
        String url = request.getHttpUrl();
        String paramsStr = url.substring(url.indexOf(63) + 1);
        Map<String, String> params = AssembleTool.getUrlParams(paramsStr);
        String orderNum = params.get("orderNum");
        String account = params.get("account");
        String goodsNum = params.get("params");
        request.setAuthParams(params);
        HttpPost httpPost = new HttpPost(this.fuluConfig.getUrl());
        FuLuBaseReq fuLuBaseReq = new FuLuBaseReq(this.fuluConfig, FuLuConfig.Api.ORDER_DIRECT_ADD.getMethodName());
        OrderDirectAddReq orderDirectAddReq = new OrderDirectAddReq();
        orderDirectAddReq.setProductId(Long.valueOf(productId));
        orderDirectAddReq.setCustomerOrderNo(orderNum);
        orderDirectAddReq.setChargeAccount(account);
        orderDirectAddReq.setBuyNum(1);
        fuLuBaseReq.setBizContent(FuLuUtils.toJSON(orderDirectAddReq));
        fuLuBaseReq.setSign(null);
        fuLuBaseReq.setSign(FuLuUtils.sign(this.fuluConfig.getSysSecret(), fuLuBaseReq));
        StringEntity stringEntity = new StringEntity(FuLuUtils.toJSON(fuLuBaseReq), "UTF-8");
        stringEntity.setContentEncoding("UTF-8");
        stringEntity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)stringEntity);
        return httpPost;
    }

    public String getVirtualResponse(SupplierRequest message, String body, String callbackTopic, String msgTag, String msgKey) {
        Map<Object, Object> duibaDoc = new HashMap<String, String>();
        try {
            FuLuBaseResp fuluBaseResp = (FuLuBaseResp)JSON.parseObject((String)body, FuLuBaseResp.class);
            duibaDoc = this.getDuibaVirtualResponse(message, fuluBaseResp, callbackTopic, msgTag, msgKey);
        }
        catch (Exception e) {
            LOGGER.error("fulu\uff0c\u5145\u503c\u5546\u54c1\u5b9a\u5236\uff0c\u7ed3\u679c\u89e3\u6790\u9519\u8bef:{}", (Object)body, (Object)e);
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", "\u798f\u7984\u76f4\u5145\u54cd\u5e94\u89e3\u6790\u9519\u8bef");
        }
        return JSON.toJSONString(duibaDoc);
    }

    private Map<String, String> getDuibaVirtualResponse(SupplierRequest message, FuLuBaseResp fuluBaseResp, String callbackTopic, String msgTag, String msgKey) {
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        if (Objects.equals(fuluBaseResp.getCode(), 0)) {
            OrderDirectAddResp orderDirectAddResp = (OrderDirectAddResp)JSON.parseObject((String)fuluBaseResp.getResult(), OrderDirectAddResp.class);
            if (StringUtils.equals((String)orderDirectAddResp.getOrderState(), (String)"success")) {
                duibaDoc.put("status", "success");
                duibaDoc.put("supplierBizId", orderDirectAddResp.getOrderId());
                return duibaDoc;
            }
            if (StringUtils.equals((String)orderDirectAddResp.getOrderState(), (String)"failed")) {
                LOGGER.warn("fulu\uff0c\u4e0b\u5355\u5931\u8d25\uff0cresp=={}", (Object)JSON.toJSONString((Object)fuluBaseResp));
                duibaDoc.put("status", "fail");
                duibaDoc.put("errorMessage", "\u51fa\u4e86\u70b9\u5c0f\u95ee\u9898\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355");
                return duibaDoc;
            }
            if (StringUtils.equals((String)orderDirectAddResp.getOrderState(), (String)"untreated") || StringUtils.equals((String)orderDirectAddResp.getOrderState(), (String)"processing")) {
                this.threadPoolService.submit(() -> this.initSave(message, callbackTopic, msgTag, msgKey));
                duibaDoc.put("status", "need-repeat-query");
                return duibaDoc;
            }
        } else {
            if (UNUSUAL_CODE.contains(fuluBaseResp.getCode())) {
                duibaDoc.put("status", "unusual");
                duibaDoc.put("errorMessage", fuluBaseResp.getMessage());
                return duibaDoc;
            }
            LOGGER.warn("fulu\uff0c\u4e0b\u5355\u5931\u8d25\uff0cresp=={}", (Object)JSON.toJSONString((Object)fuluBaseResp));
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", "\u51fa\u4e86\u70b9\u5c0f\u95ee\u9898\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355");
            return duibaDoc;
        }
        return duibaDoc;
    }

    private void initSave(SupplierRequest message, String callbackTopic, String msgTag, String msgKey) {
        VirtualSupplierProcessingOrderLogEntity entity = new VirtualSupplierProcessingOrderLogEntity();
        entity.setAppId(Long.valueOf(message.getAppId()));
        entity.setConsumerId(Long.valueOf(message.getConsumerId()));
        entity.setOrderId(Long.valueOf(message.getOrderId()));
        entity.setOrderNum(message.getParams().get("orderNum"));
        entity.setSupplierOrderId(Long.valueOf(message.getSupplierOrderId()));
        entity.setSupplierName(message.getSupplierName());
        entity.setHttpUrl(message.getHttpUrl());
        MqInfo mqInfo = new MqInfo();
        mqInfo.setMqCallbackTopic(callbackTopic);
        mqInfo.setMqTag(msgTag);
        mqInfo.setMqMsgKey(msgKey);
        entity.setMqInfo(JSON.toJSONString((Object)mqInfo));
        this.virtualSupplierProcessOrderService.initSave(entity);
    }

    public boolean customFinallyBlock(SupplierResponse response) {
        if (StringUtils.isNotBlank((String)response.getBody())) {
            JSONObject duibaResponse = JSON.parseObject((String)response.getBody());
            if (StringUtils.equals((String)((String)duibaResponse.get((Object)"status")), (String)"need-repeat-query")) {
                return false;
            }
            if (StringUtils.equals((String)((String)duibaResponse.get((Object)"status")), (String)"unusual")) {
                response.setCallbackType("failed");
            }
        }
        return true;
    }
}

