/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.constant.GreelyConfig;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpRequestLog;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GreelyApiStrategy
implements ApiStrategy {
    private static final Logger log = LoggerFactory.getLogger(GreelyApiStrategy.class);
    @Autowired
    private AppDAO appDAO;
    @Autowired
    private GreelyConfig greelyConfig;

    @Override
    public boolean isCustomCrecord(HttpRequestMessageDto dto) {
        String orderNum = (String)dto.getHttpParams().get("orderNum");
        return StringUtils.isNotBlank((CharSequence)orderNum);
    }

    @Override
    public HttpRequestBase getCrecordNotify(HttpRequestMessageDto msg2, AppDO app) {
        Map authParams = msg2.getHttpParams();
        authParams.put("appKey", app.getAppKey());
        authParams.put("appSecret", this.appDAO.getAppSecret(app));
        String sign = SignTool.sign((Map)authParams);
        authParams.put("sign", sign);
        authParams.remove("appSecret");
        String url = this.greelyConfig.getCrecordNotifyUrl();
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new ThirdpatyException("\u5409\u5229\u5151\u6362\u8bb0\u5f55\u540c\u6b65url is not config");
        }
        url = AssembleTool.assembleUrl(url, authParams);
        HttpGet http = new HttpGet(url.trim());
        HttpRequestLog.logUrl("[action crecord] [tag get request] [url " + url + "]");
        return http;
    }
}

