/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.config.HnConstants;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.dto.hn.HnAopCommonParam;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.hn.HmacSha;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HuNanLianTongApi
implements ApiStrategy {
    public static final Logger LOGGER = LoggerFactory.getLogger(HuNanLianTongApi.class);
    private static final String SUCCESS_MSG = "\u6e56\u5357\u8054\u901a\u865a\u62df\u5546\u54c1\u53d1\u653e\u6210\u529f";
    private static final String ERROR_MSG = "\u53d1\u653e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u5904\u7406";
    @Autowired
    private HnConstants hnConstants;

    @PostConstruct
    private void init() {
        ApiStrategyRouter.register(this.hnConstants.getAppIds(), this);
    }

    @Override
    public HttpRequestBase getVirtualRequest(SupplierRequest supplierRequestDto) {
        try {
            String url = supplierRequestDto.getHttpUrl();
            String newUrl = url.substring(0, url.indexOf(63));
            String queryString = url.substring(newUrl.length() + 1);
            Map<String, String> params = AssembleTool.getUrlParams(queryString);
            String bizParams = Optional.ofNullable(params.get("params")).map(s -> {
                try {
                    return URLDecoder.decode(s, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    return s;
                }
            }).orElseThrow(() -> new BizException("\u6e56\u5357\u8054\u901a\u865a\u62df\u5546\u54c1\u53d1\u653e,\u865a\u62df\u5546\u54c1\u7f16\u7801\u672a\u914d\u7f6e"));
            Map<String, String> config = Optional.ofNullable(this.hnConstants.getConfigMap().get(bizParams)).orElseThrow(() -> new BizException("\u6e56\u5357\u8054\u901a\u865a\u62df\u5546\u54c1\u53d1\u653e,\u865a\u62df\u5546\u54c1\u7f16\u7801\u914d\u7f6e\u672a\u627e\u5230"));
            String orderId = supplierRequestDto.getOrderId();
            String account = params.get("uid");
            LOGGER.info("\u6e56\u5357\u8054\u901a\u865a\u62df\u5546\u54c1\u53d1\u653e,\u8bf7\u6c42\u53c2\u6570SupplierRequestDto[{}]", (Object)JSON.toJSONString((Object)supplierRequestDto));
            return this.getHttpRequestBase(config, orderId, account);
        }
        catch (Exception e) {
            LOGGER.warn("\u6e56\u5357\u8054\u901a\u865a\u62df\u5546\u54c1\u53d1\u653e\u5931\u8d25, supplierRequestDto={}", (Object)JSON.toJSONString((Object)supplierRequestDto), (Object)e);
            return null;
        }
    }

    @NotNull
    private HttpRequestBase getHttpRequestBase(Map<String, String> config, String orderId, String account) throws Exception {
        HnAopCommonParam reqParam = new HnAopCommonParam();
        reqParam.setMethod("ABILITY_10004414");
        reqParam.setFormat("json");
        reqParam.setAppId("501367");
        reqParam.setOperId("1");
        reqParam.setAccessToken("58d238d7-45ff-4f02-bc94-6cd93c5fff2c");
        reqParam.setBusiSerial(orderId);
        reqParam.setVersion("1");
        reqParam.setOpenId("1");
        reqParam.setRegionId(this.hnConstants.getRegionId());
        HashMap content = Maps.newHashMap();
        TreeMap header = Maps.newTreeMap();
        header.put("source", "lalianwangluo");
        header.put("principal", "A0WXZC");
        header.put("transId", orderId);
        header.put("timestamp", new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()));
        String stringTmp = Joiner.on((char)'&').useForNull("").withKeyValueSeparator("=").join((Map)header);
        String token = stringTmp + "&" + this.hnConstants.getSignKey();
        header.put("token", DigestUtils.md5Hex((String)token).toLowerCase());
        content.put("head", header);
        HashMap body = Maps.newHashMap();
        HashMap smsInfo = Maps.newHashMap();
        smsInfo.put("sms_content", config.get("smsContent"));
        smsInfo.put("sms_type", "2");
        body.put("smsInfo", smsInfo);
        body.put("orderId", orderId);
        body.put("isSynRedis", "0");
        body.put("benefitType", config.get("benefitType"));
        body.put("fee", "0");
        body.put("isSendSms", "1");
        body.put("beneficiary", account);
        body.put("touchType", "99");
        body.put("triggerType", "05");
        ArrayList rights = Lists.newArrayList();
        HashMap right = Maps.newHashMap();
        right.put("benefitId", config.get("benefitId"));
        right.put("right_type", "3");
        rights.add(right);
        body.put("rights", rights);
        content.put("body", body);
        reqParam.setContent(JSON.toJSONString((Object)content));
        reqParam.setSignKey(this.hnConstants.getAppKey());
        reqParam.setHnaopAddress(this.hnConstants.getHnaopAddress());
        LOGGER.info("\u6e56\u5357\u8054\u901a\u865a\u62df\u5546\u54c1\u53d1\u653e,reqParam[{}]", (Object)JSON.toJSONString((Object)reqParam));
        return HuNanLianTongApi.sendRequest(reqParam);
    }

    @Override
    public String getVirtualResponse(SupplierRequest request, String body) {
        LOGGER.info("\u6e56\u5357\u8054\u901a\u865a\u62df\u5546\u54c1\u53d1\u653e,\u54cd\u5e94\u7ed3\u679c,body={}", (Object)body);
        JSONObject response = JSON.parseObject((String)body);
        if (response == null) {
            LOGGER.warn("\u6e56\u5357\u8054\u901a\u865a\u62df\u5546\u54c1\u53d1\u653e,\u54cd\u5e94\u5931\u8d25,body={}", (Object)body);
            return this.buildResponse(request, ERROR_MSG, "failed");
        }
        String respCode = response.getString("respCode");
        String respDesc = response.getString("respDesc");
        if (!Objects.equals("00000", respCode)) {
            LOGGER.warn("\u6e56\u5357\u8054\u901a\u865a\u62df\u5546\u54c1\u53d1\u653e,\u54cd\u5e94\u5931\u8d25,body={}", (Object)body);
            String msg2 = StringUtils.isNotBlank((CharSequence)respDesc) ? new String(respDesc.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8) : ERROR_MSG;
            return this.buildResponse(request, msg2, "failed");
        }
        JSONObject bodyObject = Optional.ofNullable(response.getJSONObject("result")).map(jsonObject -> jsonObject.getJSONObject("body")).orElse(new JSONObject());
        String rspCode = bodyObject.getString("rspCode");
        String rspDesc = bodyObject.getString("rspDesc");
        if (Objects.equals("0000", rspCode)) {
            return this.buildResponse(request, SUCCESS_MSG, "completed");
        }
        LOGGER.warn("\u6e56\u5357\u8054\u901a\u865a\u62df\u5546\u54c1\u53d1\u653e,\u54cd\u5e94\u5931\u8d25,body={}", (Object)body);
        String msg3 = StringUtils.isNotBlank((CharSequence)rspCode) ? "\u5f00\u53d1\u8005\u54cd\u5e94\u9519\u8bef\u7801:" + rspCode : ERROR_MSG;
        return this.buildResponse(request, msg3, "failed");
    }

    private String buildResponse(SupplierRequest requestDto, String errorMessage, String callbackType) {
        HashMap<String, String> params = new HashMap<String, String>(1);
        if ("completed".equals(callbackType)) {
            params.put("status", "success");
        } else {
            params.put("status", "fail");
            params.put("errorMessage", errorMessage);
        }
        return JSON.toJSONString(params);
    }

    private static HttpRequestBase sendRequest(HnAopCommonParam reqParam) throws Exception {
        HttpPost reusultStr = null;
        try {
            SimpleDateFormat df_stamp = new SimpleDateFormat("yyyyMMddHHmmss");
            String timestampNow = df_stamp.format(new Date());
            HashMap<String, String> param = new HashMap<String, String>();
            if (reqParam == null) {
                throw new Exception("\u8bf7\u6c42\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            }
            if (reqParam.getMethod() == null) {
                throw new Exception("\u80fd\u529b\u7f16\u7801method\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            }
            if (reqParam.getFormat() == null) {
                throw new Exception("\u4e1a\u52a1\u53c2\u6570\u683c\u5f0fformat\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            }
            if (reqParam.getBusiSerial() == null) {
                throw new Exception("\u4e1a\u52a1\u6d41\u6c34busiSerial\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            }
            if (reqParam.getAppId() == null) {
                throw new Exception("\u5e94\u7528\u8005\u7f16\u7801appId\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            }
            if (reqParam.getOperId() == null) {
                throw new Exception("\u64cd\u4f5c\u8005\u7f16\u7801operId\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            }
            if (reqParam.getRegionId() == null) {
                throw new Exception("\u8def\u7531\u7f16\u7801RegionId\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            }
            if (reqParam.getContent() == null) {
                throw new Exception("\u4e1a\u52a1\u8bf7\u6c42\u53c2\u6570content\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            }
            if (reqParam.getHnaopAddress() == null) {
                throw new Exception("\u8bf7\u6c42\u5730\u5740hnaopAddress\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            }
            String hnaopAddress = reqParam.getHnaopAddress();
            param.put("method", reqParam.getMethod());
            param.put("format", reqParam.getFormat());
            param.put("busiSerial", reqParam.getBusiSerial());
            param.put("appId", reqParam.getAppId());
            param.put("operId", reqParam.getOperId());
            param.put("timestamp", timestampNow);
            param.put("openId", reqParam.getOpenId());
            param.put("accessToken", reqParam.getAccessToken());
            param.put("version", reqParam.getVersion());
            param.put("RegionId", reqParam.getRegionId());
            param.put("content", reqParam.getContent());
            String signKey = reqParam.getSignKey();
            ArrayList keys = new ArrayList(param.keySet());
            Collections.sort(keys);
            String prestr = signKey;
            for (int i = 0; i < keys.size(); ++i) {
                String key = (String)keys.get(i);
                String value = (String)param.get(key);
                prestr = prestr + key + value;
            }
            prestr = prestr + signKey;
            param.put("sign", HmacSha.encryptHMAC(prestr, signKey));
            param.put("postEntityString", reqParam.getContent());
            param.remove("content");
            reusultStr = HuNanLianTongApi.doPost("10000", hnaopAddress, "utf-8", param);
            return reusultStr;
        }
        catch (Exception var12) {
            var12.printStackTrace();
            throw var12;
        }
    }

    public static HttpPost doPost(String idCode, String url, String charset, Map<String, String> dataMap) throws Exception {
        String paramStr = "";
        String postStr = "";
        String urlStr = "";
        if (idCode != null && !"".equals(idCode) && idCode.equalsIgnoreCase("10000")) {
            if (!dataMap.containsKey("postEntityString")) {
                throw new Exception("key\u503c\u4e3apostEntityString\u7684\u6d88\u606f\u4f53\u4e0d\u80fd\u4e3a\u7a7a");
            }
            postStr = dataMap.get("postEntityString");
            dataMap.remove("postEntityString");
            if (dataMap != null && !dataMap.isEmpty()) {
                for (String key : dataMap.keySet()) {
                    paramStr = paramStr + "&" + key + "=" + dataMap.get(key).trim();
                }
            }
        } else {
            if (dataMap != null && !dataMap.isEmpty()) {
                for (String key : dataMap.keySet()) {
                    postStr = postStr + "&" + key + "=" + dataMap.get(key).trim();
                }
            }
            if (postStr != null && !"".equals(postStr) && postStr.length() > 1) {
                postStr = postStr.substring(1);
            }
        }
        if (url == null || "".equals(url)) {
            throw new Exception("\u8bf7\u6c42url\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (url.indexOf("?") == -1) {
            if (paramStr != null && !"".equals(paramStr) && paramStr.length() > 1) {
                paramStr = paramStr.substring(1);
                urlStr = url + "?" + paramStr;
            } else {
                urlStr = url;
            }
        } else {
            urlStr = url + paramStr;
        }
        return HuNanLianTongApi.doPost(charset, postStr, urlStr);
    }

    private static HttpPost doPost(String charset, String postStr, String urlStr) throws IOException {
        HttpPost httpPost = new HttpPost(urlStr);
        httpPost.setConfig(RequestConfig.custom().setSocketTimeout(60000).setConnectionRequestTimeout(100).build());
        httpPost.setHeader("accept", "*/*");
        httpPost.setHeader("connection", "Keep-Alive");
        httpPost.setHeader("user-agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) ...");
        StringEntity stringEntity = new StringEntity(postStr, charset);
        stringEntity.setContentEncoding(charset);
        stringEntity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)stringEntity);
        return httpPost;
    }
}

