/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.config.YingdaConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class YingdaApiStrategy
implements ApiStrategy {
    private static final Logger log = LoggerFactory.getLogger(YingdaApiStrategy.class);
    private static final String CHARACTER_ENCODE = "UTF-8";
    private static final String APPLICATION_JSON = "application/json";
    private static final String LOG_HEAD = "\u82f1\u5927\u8bc1\u5238";
    private static final String SUCCESS = "200";
    @Autowired
    private YingdaConfig yingdaConfig;

    @Override
    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        log.info("{}\u6263\u79ef\u5206\u5f00\u59cb", (Object)LOG_HEAD);
        return null;
    }

    @Override
    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams) {
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        duibaDoc.put("bizId", authParams.get("orderNum"));
        duibaDoc.put("credits", authParams.get("credits"));
        duibaDoc.put("status", "fail");
        log.info("{}\u79ef\u5206\u54cd\u5e94\u4f53\uff1a{}", (Object)LOG_HEAD, (Object)body);
        if (addCredits.booleanValue()) {
            JSONObject jsonObject = JSONObject.parseObject((String)body);
            String flag = jsonObject.getString("code");
            if (SUCCESS.equals(flag)) {
                duibaDoc.put("status", "ok");
                JSONObject data = jsonObject.getJSONObject("data");
                if (data != null) {
                    duibaDoc.put("bizId", data.getString("log_id"));
                }
            } else {
                log.warn("{}\u52a0\u79ef\u5206\u54cd\u5e94\u5931\u8d25\uff1a{}", (Object)LOG_HEAD, (Object)body);
                duibaDoc.put("errorMessage", jsonObject.getString("msg"));
            }
        }
        return JsonTool.objectToJson(duibaDoc);
    }

    @Override
    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        try {
            log.info("{}\u52a0\u79ef\u5206\u8bf7\u6c42 :{}", (Object)LOG_HEAD, (Object)JSON.toJSONString((Object)message));
            String url = message.getHttpUrl();
            String host = url.substring(0, url.indexOf(63));
            Map<String, String> body = this.buildParam(message);
            log.info("{}\u52a0\u79ef\u5206\u8bf7\u6c42\u53c2\u6570{}", (Object)LOG_HEAD, (Object)JSONObject.toJSONString(body));
            HttpPost httpPost = new HttpPost(host);
            this.buildHeader(httpPost, body);
            ArrayList pairs = new ArrayList(body.size());
            body.entrySet().forEach(e -> pairs.add(new BasicNameValuePair((String)e.getKey(), (String)e.getValue())));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, CHARACTER_ENCODE));
            return httpPost;
        }
        catch (Exception e2) {
            log.warn("{}\u52a0\u79ef\u5206\u8bf7\u6c42\u5f02\u5e38", (Object)LOG_HEAD, (Object)e2);
            return null;
        }
    }

    public void buildHeader(HttpPost httpPost, Map<String, String> body) {
        TreeMap<String, String> header = new TreeMap<String, String>();
        String time = String.valueOf(System.currentTimeMillis() / 1000L);
        String randNum = String.valueOf(RandomUtils.nextInt((int)100000, (int)999999));
        header.put("appId", this.yingdaConfig.getDeveloperAppId());
        header.put("randNum", randNum);
        header.put("time", time);
        StringBuilder stringBuilder = new StringBuilder();
        String orderStr = body.entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("&"));
        String noSignStr = stringBuilder.append(this.yingdaConfig.getDeveloperAppId()).append(time).append(randNum).append(this.yingdaConfig.getDeveloperAppSecret()).append(orderStr).toString();
        String sign = DigestUtils.md5Hex((String)noSignStr);
        header.put("sign", sign);
        header.entrySet().forEach(e -> httpPost.addHeader((String)e.getKey(), (String)e.getValue()));
        log.info("{}\u52a0\u79ef\u5206\u8bf7\u6c42header={}", (Object)LOG_HEAD, (Object)JSONObject.toJSONString(header));
    }

    public Map<String, String> buildParam(CreditsMessageDto messageDto) {
        Map authParams = messageDto.getAuthParams();
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put("userId", (String)authParams.get("uid"));
        paramMap.put("credit", (String)authParams.get("credits"));
        paramMap.put("mark", (String)authParams.get("description"));
        paramMap.put("reward", (String)authParams.get("orderNum"));
        paramMap.put("reward_id", messageDto.getRelationId());
        return paramMap;
    }

    @Override
    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record) {
        log.info("{}\u83b7\u53d6\u5151\u6362\u7ed3\u679c\u901a\u77e5", (Object)LOG_HEAD);
        return null;
    }
}

