/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.config;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="order.status.push")
public class OrderStatusPushConfig
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrderStatusPushConfig.class);
    private String configStr = "[{\"appIds\":[18705,1],\"pushUrl\":\"http://127.0.0.1:7855/taw/alipay/orderNotify\",\"perm\":1}]";
    private Map<Long, OrderStatusPushBean> configMap;

    public String getConfigStr() {
        return this.configStr;
    }

    public void setConfigStr(String configStr) {
        this.configStr = configStr;
    }

    public Map<Long, OrderStatusPushBean> getConfigMap() {
        return this.configMap;
    }

    public void setConfigMap(Map<Long, OrderStatusPushBean> configMap) {
        this.configMap = configMap;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            if (StringUtils.isNotBlank((String)this.configStr)) {
                this.configMap = new HashMap<Long, OrderStatusPushBean>();
                List configList = JSON.parseArray((String)this.configStr, OrderStatusPushBean.class);
                for (OrderStatusPushBean bean : configList) {
                    for (Long appId : bean.getAppIds()) {
                        OrderStatusPushBean oldvalue = this.configMap.put(appId, bean);
                        if (oldvalue == null) continue;
                        LOGGER.warn("\u8ba2\u5355\u63a8\u9001\u6709\u91cd\u590d\u914d\u7f6e");
                    }
                }
            }
            LOGGER.info("\u8ba2\u5355\u63a8\u9001\u914d\u7f6e\u4fe1\u606f:{}", (Object)JSON.toJSONString(this.configMap));
        }
        catch (Exception e) {
            LOGGER.warn("\u8ba2\u5355\u63a8\u9001\u914d\u7f6e\u521d\u59cb\u5316\u5931\u8d25\uff0cconfigStr={}", (Object)this.configStr);
        }
    }

    public static class OrderStatusPushBean {
        private List<Long> appIds;
        private String pushUrl;
        private Long perm;

        public List<Long> getAppIds() {
            return this.appIds;
        }

        public void setAppIds(List<Long> appIds) {
            this.appIds = appIds;
        }

        public String getPushUrl() {
            return this.pushUrl;
        }

        public void setPushUrl(String pushUrl) {
            this.pushUrl = pushUrl;
        }

        public Long getPerm() {
            return this.perm;
        }

        public void setPerm(Long perm) {
            this.perm = perm;
        }
    }
}

