/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.constant;

import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="delay.notify")
public class DelayNotifyConfig {
    private static final Map<Long, Integer> DELAY_LEVELS = new ConcurrentHashMap<Long, Integer>(256);
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiStrategyRouter.class);
    private Set<Long> appIds = Sets.newHashSet((Object[])new Long[]{-1L});

    public Set<Long> getAppIds() {
        return this.appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    public boolean ifNeedDelay(Long appId) {
        return this.appIds.contains(appId);
    }

    public static void setDelayLevels(Set<Long> appIds, Integer delayLevel) {
        for (Long appId : appIds) {
            DELAY_LEVELS.put(appId, delayLevel);
        }
        LOGGER.info("\u901a\u77e5\u6d88\u606f\u5ef6\u65f6\u914d\u7f6e DELAY_LEVELS = {}", (Object)JSON.toJSONString(DELAY_LEVELS));
    }

    public static Integer getDelayLevels(Long appId) {
        return DELAY_LEVELS.get(appId);
    }
}

