/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.constant;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="guoben")
public class GuoBenConfig
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(GuoBenConfig.class);
    private String configStr = "[{\"accountType\":0,\"appId\":81405,\"brandCode\":\"GB\",\"createBy\":\"duiba\",\"url\":\"http://40.73.163.222:32099\"},{\"accountType\":0,\"appId\":83769,\"brandCode\":\"GB\",\"createBy\":\"duiba\",\"url\":\"http://40.73.163.222:32099\"}]";
    private Map<Long, GuoBenConfigBean> configMap;

    public String getConfigStr() {
        return this.configStr;
    }

    public void setConfigStr(String configStr) {
        this.configStr = configStr;
    }

    public Map<Long, GuoBenConfigBean> getConfigMap() {
        return this.configMap;
    }

    public void setConfigMap(Map<Long, GuoBenConfigBean> configMap) {
        this.configMap = configMap;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            if (StringUtils.isNotBlank((String)this.configStr)) {
                this.configMap = JSON.parseArray((String)this.configStr, GuoBenConfigBean.class).stream().collect(Collectors.toMap(GuoBenConfigBean::getAppId, Function.identity(), (a, b) -> a));
            }
        }
        catch (Exception e) {
            LOGGER.warn("\u679c\u672c\u5b9a\u5236\uff0c\u914d\u7f6e\u521d\u59cb\u5316\u5931\u8d25\uff0cconfigStr={}", (Object)this.configStr);
        }
    }

    public static class GuoBenConfigBean {
        private Long appId;
        private String url;
        private Integer accountType;
        private String brandCode;
        private String createBy;

        public Long getAppId() {
            return this.appId;
        }

        public void setAppId(Long appId) {
            this.appId = appId;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Integer getAccountType() {
            return this.accountType;
        }

        public void setAccountType(Integer accountType) {
            this.accountType = accountType;
        }

        public String getBrandCode() {
            return this.brandCode;
        }

        public void setBrandCode(String brandCode) {
            this.brandCode = brandCode;
        }

        public String getCreateBy() {
            return this.createBy;
        }

        public void setCreateBy(String createBy) {
            this.createBy = createBy;
        }

        public static void main(String[] args) {
            ArrayList list = Lists.newArrayList();
            GuoBenConfigBean realBean = new GuoBenConfigBean();
            realBean.setAppId(81405L);
            realBean.setUrl("http://40.73.163.222:32099");
            realBean.setAccountType(0);
            realBean.setBrandCode("GB");
            realBean.setCreateBy("duiba");
            list.add(realBean);
            GuoBenConfigBean testBean = new GuoBenConfigBean();
            testBean.setAppId(83769L);
            testBean.setUrl("http://40.73.163.222:32099");
            testBean.setAccountType(0);
            testBean.setBrandCode("GB");
            testBean.setCreateBy("duiba");
            list.add(testBean);
            System.out.println(JSON.toJSONString((Object)list));
        }
    }

    public static enum Api {
        GET_TOKEN("/system/user/getTokenByStaffIdOrCode?code=duiba"),
        CHANGE_MEMBER_INTEGRAL("/integration/member/member/changeMemberIntegral"),
        GET_INTEGRAL("/integration/member/member/getIntegral");

        String path;

        private Api(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public String getApiAbsolutePath(GuoBenConfigBean config) {
            return config.getUrl() + this.getPath();
        }
    }
}

