/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.constant;

import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.biz.credits.strategy.Impl.JingDongApiStrategy;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="jingdong")
public class JingDongConfig
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(JingDongConfig.class);
    @Autowired
    private JingDongApiStrategy jingDongApiStrategy;
    private String configStr = "[{\"appId\":19543,\"shopId\":10139787,\"venderId\":10276497},{\"appId\":84507,\"shopId\":1000001469,\"venderId\":1000001469}]";
    private String url = "https://duiba-isv.isvjcloud.com";
    private Map<Long, JingDongConfigBean> configMap;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getConfigStr() {
        return this.configStr;
    }

    public void setConfigStr(String configStr) {
        this.configStr = configStr;
    }

    public Map<Long, JingDongConfigBean> getConfigMap() {
        return this.configMap;
    }

    public void setConfigMap(Map<Long, JingDongConfigBean> configMap) {
        this.configMap = configMap;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            if (StringUtils.isNotBlank((String)this.configStr)) {
                this.configMap = JSON.parseArray((String)this.configStr, JingDongConfigBean.class).stream().collect(Collectors.toMap(JingDongConfigBean::getAppId, Function.identity(), (a, b) -> a));
            }
            LOGGER.info("\u4eac\u4e1c\u5b9a\u5236\uff0c\u914d\u7f6e\u521d\u59cb\u5316\u6210\u529f\uff0cconfigStr={}", (Object)this.configStr);
        }
        catch (Exception e) {
            LOGGER.warn("\u4eac\u4e1c\u5b9a\u5236\uff0c\u914d\u7f6e\u521d\u59cb\u5316\u5931\u8d25\uff0cconfigStr={}", (Object)this.configStr);
        }
        LOGGER.info("\u4eac\u4e1c\u5f00\u59cb\u6ce8\u518c\u7b56\u7565---------");
        ApiStrategyRouter.register(this.configMap.keySet(), this.jingDongApiStrategy);
    }

    public static class JingDongConfigBean {
        private Long appId;
        private Long venderId;
        private Long shopId;

        public Long getAppId() {
            return this.appId;
        }

        public void setAppId(Long appId) {
            this.appId = appId;
        }

        public Long getVenderId() {
            return this.venderId;
        }

        public void setVenderId(Long venderId) {
            this.venderId = venderId;
        }

        public Long getShopId() {
            return this.shopId;
        }

        public void setShopId(Long shopId) {
            this.shopId = shopId;
        }

        public static void main(String[] args) {
            ArrayList beanList = Lists.newArrayList();
            JingDongConfigBean bean1 = new JingDongConfigBean();
            bean1.setAppId(19543L);
            bean1.setVenderId(10276497L);
            bean1.setShopId(10139787L);
            beanList.add(bean1);
            JingDongConfigBean bean2 = new JingDongConfigBean();
            bean2.setAppId(84507L);
            bean2.setVenderId(1000001469L);
            bean2.setShopId(1000001469L);
            beanList.add(bean2);
            System.out.println(JSON.toJSONString((Object)beanList));
        }
    }

    public static enum Api {
        CONSUMER_POINTS("/open2Duiba/consumePoints"),
        GET_CUSTOMER_POINTS("/open2Duiba/getCustomerPoints");

        String path;

        private Api(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public String getApiAbsolutePath(JingDongConfig config) {
            return config.getUrl() + this.getPath();
        }
    }
}

