/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.constant.livat;

import cn.com.duiba.constant.livat.LivatConfig;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="livat")
public class LivatConstant
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(LivatConstant.class);
    private Set<Long> appId = Sets.newHashSet();
    private String vipInfoApiUrl = "https://openapi10.mallcoo.cn/User/AdvancedInfo/v1/GetMemberInfo/ByMobile/";
    private String creditsAddUrl = "https://openapi10.mallcoo.cn/User/Score/v1/Plus/ByMobile/";
    private String config = "[{\"appId\":76025,\"developerAppId\":\"5f0d8e504bae7051c88ad953\",\"developerPublicKey\":\"-Ham7p\",\"developerPrivateKey\":\"152fe116c89bc527\"},{\"appId\":78198,\"developerAppId\":\"5f64643b4ba1f23bb875c1d0\",\"developerPublicKey\":\"zkQMJB\",\"developerPrivateKey\":\"b0eb52550c31fc6c\"}]";
    private Map<Long, LivatConfig> configParamsMap = Maps.newHashMap();

    public void afterPropertiesSet() {
        if (StringUtils.isBlank((CharSequence)this.config)) {
            return;
        }
        try {
            List clientConfigs = JSONObject.parseArray((String)this.config, LivatConfig.class);
            if (CollectionUtils.isNotEmpty((Collection)clientConfigs)) {
                this.configParamsMap = clientConfigs.stream().collect(Collectors.toMap(LivatConfig::getAppId, f -> f));
                this.appId = clientConfigs.stream().map(LivatConfig::getAppId).collect(Collectors.toSet());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u835f\u805a\u4e2d\u5fc3\u914d\u7f6e\u9519\u8bef", (Throwable)e);
        }
    }

    public String getCreditsAddUrl() {
        return this.creditsAddUrl;
    }

    public Set<Long> getAppId() {
        return this.appId;
    }

    public void setAppId(Set<Long> appId) {
        this.appId = appId;
    }

    public String getVipInfoApiUrl() {
        return this.vipInfoApiUrl;
    }

    public void setVipInfoApiUrl(String vipInfoApiUrl) {
        this.vipInfoApiUrl = vipInfoApiUrl;
    }

    public void setCreditsAddUrl(String creditsAddUrl) {
        this.creditsAddUrl = creditsAddUrl;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public Map<Long, LivatConfig> getConfigParamsMap() {
        return this.configParamsMap;
    }

    public void setConfigParamsMap(Map<Long, LivatConfig> configParamsMap) {
        this.configParamsMap = configParamsMap;
    }
}

