/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.constant.zhiji;

import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.biz.credits.strategy.Impl.ZhiJiApiStrategy;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="zhiji")
public class ZhiJiConfig
implements InitializingBean {
    private Set<Long> appIds = Sets.newHashSet((Object[])new Long[]{19592L});
    private List<String> falseTmplateId = Lists.newArrayList((Object[])new String[]{"10068"});
    private List<String> shipTmplateId = Lists.newArrayList((Object[])new String[]{"10069"});
    private List<String> receviedTmplateId = Lists.newArrayList((Object[])new String[]{"10070"});
    public String domainName = "https://duiba.immotors.com:18443";
    public Integer first = 0;
    public Integer second = 0;
    public String hmacKey = "Authorization-Proxy";
    public String hmacDateKey = "x-date";
    public String saveAddressUrl = "/umc-tsp/address/add";
    public String updateAddressUrl = "/umc-tsp/address/update";
    public String selectUserAddressUrl = "/umc-tsp/address/query";
    public String removeAddressUrl = "/umc-tsp/address/remove";
    public String selectDistrictUrl = "/cmc-lbs/baseDistrict";
    public String queryUserInfoUrl = "/external/v1/user/info";
    public String pushMessageUrl = "/msg/sendPush";
    public String subCreditsUrl = "/im/v1.0/service/IMMemberCenterTransaction/IMRedeemPoints";
    public String addCreditsUrl = "/im/v1.0/service/IMMemberCenterTransaction/IMAccruePoints";
    public String userCreditsUrl = "/im/v1.0/service/points/getPoints";
    public String syncOrderUrl = "/im/v1.0/service/weborderService/createWebOrderDetail";
    public String syncOrderStatusUrl = "/im/v1.0/service/weborderService/updateWebOrderStatus";
    public String syncGoodsUrl = "/im/v1.0/service/weborderService/createWebProdutDetail";
    public String queryOrderAddressListUrl = "/im/v1.0/service/weborderService/queryWebOrderList";
    public String insertWebOrderExpressUrl = "/im/v1.0/service/weborderService/upsertWebOrderExpress";
    public String blindBoxVerifyUrl = "/fortunebox/api/app/external/validated/gift";
    public String notifyBlindBoxUrl = "/fortunebox/api/app/external/writeOff/gift";
    public String queryProtocolUrl = "/cmc-protocol/protocol/query";
    public String getProtocolVersionUrl = "/cmc-protocol/protocol/getVersion";
    public String signProtocolUrl = "/cmc-protocol/protocol/sign";
    @Resource
    private ZhiJiApiStrategy zhiJiApiStrategy;

    public Integer getFirst() {
        return this.first;
    }

    public void setFirst(Integer first) {
        this.first = first;
    }

    public Integer getSecond() {
        return this.second;
    }

    public void setSecond(Integer second) {
        this.second = second;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public Boolean isVerifyZhiJi(Long appId) {
        return this.appIds.contains(appId);
    }

    public Set<Long> getAppIds() {
        return this.appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    public String getHmacKey() {
        return this.hmacKey;
    }

    public void setHmacKey(String hmacKey) {
        this.hmacKey = hmacKey;
    }

    public String getHmacDateKey() {
        return this.hmacDateKey;
    }

    public void setHmacDateKey(String hmacDateKey) {
        this.hmacDateKey = hmacDateKey;
    }

    public void afterPropertiesSet() throws Exception {
        ApiStrategyRouter.register(this.appIds, this.zhiJiApiStrategy);
    }

    public String getSaveAddressUrl() {
        return this.saveAddressUrl;
    }

    public void setSaveAddressUrl(String saveAddressUrl) {
        this.saveAddressUrl = saveAddressUrl;
    }

    public String getUpdateAddressUrl() {
        return this.updateAddressUrl;
    }

    public void setUpdateAddressUrl(String updateAddressUrl) {
        this.updateAddressUrl = updateAddressUrl;
    }

    public String getSelectUserAddressUrl() {
        return this.selectUserAddressUrl;
    }

    public void setSelectUserAddressUrl(String selectUserAddressUrl) {
        this.selectUserAddressUrl = selectUserAddressUrl;
    }

    public String getRemoveAddressUrl() {
        return this.removeAddressUrl;
    }

    public void setRemoveAddressUrl(String removeAddressUrl) {
        this.removeAddressUrl = removeAddressUrl;
    }

    public String getSelectDistrictUrl() {
        return this.selectDistrictUrl;
    }

    public void setSelectDistrictUrl(String selectDistrictUrl) {
        this.selectDistrictUrl = selectDistrictUrl;
    }

    public String getQueryUserInfoUrl() {
        return this.queryUserInfoUrl;
    }

    public void setQueryUserInfoUrl(String queryUserInfoUrl) {
        this.queryUserInfoUrl = queryUserInfoUrl;
    }

    public String getPushMessageUrl() {
        return this.pushMessageUrl;
    }

    public void setPushMessageUrl(String pushMessageUrl) {
        this.pushMessageUrl = pushMessageUrl;
    }

    public String getSubCreditsUrl() {
        return this.subCreditsUrl;
    }

    public void setSubCreditsUrl(String subCreditsUrl) {
        this.subCreditsUrl = subCreditsUrl;
    }

    public String getAddCreditsUrl() {
        return this.addCreditsUrl;
    }

    public void setAddCreditsUrl(String addCreditsUrl) {
        this.addCreditsUrl = addCreditsUrl;
    }

    public String getUserCreditsUrl() {
        return this.userCreditsUrl;
    }

    public void setUserCreditsUrl(String userCreditsUrl) {
        this.userCreditsUrl = userCreditsUrl;
    }

    public String getSyncOrderUrl() {
        return this.syncOrderUrl;
    }

    public void setSyncOrderUrl(String syncOrderUrl) {
        this.syncOrderUrl = syncOrderUrl;
    }

    public String getSyncOrderStatusUrl() {
        return this.syncOrderStatusUrl;
    }

    public void setSyncOrderStatusUrl(String syncOrderStatusUrl) {
        this.syncOrderStatusUrl = syncOrderStatusUrl;
    }

    public String getSyncGoodsUrl() {
        return this.syncGoodsUrl;
    }

    public void setSyncGoodsUrl(String syncGoodsUrl) {
        this.syncGoodsUrl = syncGoodsUrl;
    }

    public String getQueryOrderAddressListUrl() {
        return this.queryOrderAddressListUrl;
    }

    public void setQueryOrderAddressListUrl(String queryOrderAddressListUrl) {
        this.queryOrderAddressListUrl = queryOrderAddressListUrl;
    }

    public String getBlindBoxVerifyUrl() {
        return this.blindBoxVerifyUrl;
    }

    public String getInsertWebOrderExpressUrl() {
        return this.insertWebOrderExpressUrl;
    }

    public void setInsertWebOrderExpressUrl(String insertWebOrderExpressUrl) {
        this.insertWebOrderExpressUrl = insertWebOrderExpressUrl;
    }

    public void setBlindBoxVerifyUrl(String blindBoxVerifyUrl) {
        this.blindBoxVerifyUrl = blindBoxVerifyUrl;
    }

    public String getNotifyBlindBoxUrl() {
        return this.notifyBlindBoxUrl;
    }

    public void setNotifyBlindBoxUrl(String notifyBlindBoxUrl) {
        this.notifyBlindBoxUrl = notifyBlindBoxUrl;
    }

    public String getQueryProtocolUrl() {
        return this.queryProtocolUrl;
    }

    public void setQueryProtocolUrl(String queryProtocolUrl) {
        this.queryProtocolUrl = queryProtocolUrl;
    }

    public String getGetProtocolVersionUrl() {
        return this.getProtocolVersionUrl;
    }

    public void setGetProtocolVersionUrl(String getProtocolVersionUrl) {
        this.getProtocolVersionUrl = getProtocolVersionUrl;
    }

    public String getSignProtocolUrl() {
        return this.signProtocolUrl;
    }

    public void setSignProtocolUrl(String signProtocolUrl) {
        this.signProtocolUrl = signProtocolUrl;
    }

    public ZhiJiApiStrategy getZhiJiApiStrategy() {
        return this.zhiJiApiStrategy;
    }

    public void setZhiJiApiStrategy(ZhiJiApiStrategy zhiJiApiStrategy) {
        this.zhiJiApiStrategy = zhiJiApiStrategy;
    }

    public List<String> getFalseTmplateId() {
        return this.falseTmplateId;
    }

    public void setFalseTmplateId(List<String> falseTmplateId) {
        this.falseTmplateId = falseTmplateId;
    }

    public List<String> getShipTmplateId() {
        return this.shipTmplateId;
    }

    public void setShipTmplateId(List<String> shipTmplateId) {
        this.shipTmplateId = shipTmplateId;
    }

    public List<String> getReceviedTmplateId() {
        return this.receviedTmplateId;
    }

    public void setReceviedTmplateId(List<String> receviedTmplateId) {
        this.receviedTmplateId = receviedTmplateId;
    }
}

