/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.mq.dinghandler;

import cn.com.duiba.api.bo.mq.DingTextMessage;
import cn.com.duiba.api.enums.mq.RocketMqTagEnum;
import cn.com.duiba.mq.dinghandler.SendDingMsgHelper;
import cn.com.duiba.mq.dinghandler.SendDingMsgTagIHandler;
import cn.com.duiba.service.DingService;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SendTextDingMsgTagIHandler
implements SendDingMsgTagIHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SendTextDingMsgTagIHandler.class);
    @Autowired
    private DingService dingService;

    @PostConstruct
    public void registerTagHandler() {
        SendDingMsgHelper.registerTagHandler(this);
    }

    @Override
    public String getTag() {
        return RocketMqTagEnum.THIRDPARTY_DING_TEXT_MSG.getTag();
    }

    @Override
    public boolean handleMQMessage(byte[] mqMessage) {
        DingTextMessage textMessage = DingTextMessage.decode((byte[])mqMessage);
        if (textMessage == null) {
            LOGGER.warn("DingTextMessage decode failed");
            return false;
        }
        return this.dingService.sendDingQunMessage(textMessage.getDingToken(), textMessage.getContent(), textMessage.getToAtAll());
    }
}

