/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.orderstatus;

import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.dao.HttpMessageDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.HttpMessageDO;
import cn.com.duiba.job.AbstractDuibaSimpleElasticJob;
import cn.com.duiba.orderstatus.OrderStatusPushHttp;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSONObject;
import io.elasticjob.autoconfigure.annotation.ElasticJob;
import io.elasticjob.lite.api.ShardingContext;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ElasticJob(name="orderPushRetryJob", cron="0/30 * * * * ?", shardingTotalCount=1, overwrite=true)
public class OrderPushRetryJob
extends AbstractDuibaSimpleElasticJob {
    private Logger log = LoggerFactory.getLogger(OrderPushRetryJob.class);
    @Autowired
    private HttpMessageDAO httpMessageDAO;
    @Autowired
    private OrderStatusPushHttp toDeveloper;
    @Autowired
    private AppDAO appDAO;

    @Override
    public void doProcess(ShardingContext shardingContext) {
        try {
            AppDO app;
            this.log.info("started retry orderStatusPush:{}", (Object)DateUtils.getSecondStr((Date)new Date()));
            List<HttpMessageDO> dos = this.httpMessageDAO.findNeedRetry("orderStatusPush", 5000);
            HashMap<Long, AppDO> appMap = new HashMap<Long, AppDO>();
            HashSet<Long> appIds = new HashSet<Long>();
            for (HttpMessageDO db : dos) {
                appIds.add(db.getAppId());
            }
            for (Long appId : appIds) {
                app = this.appDAO.findAppSimple(appId);
                appMap.put(appId, app);
            }
            for (HttpMessageDO db : dos) {
                app = (AppDO)appMap.get(db.getAppId());
                HttpRequestMessageDto dto = new HttpRequestMessageDto();
                dto.setAppId(db.getAppId());
                dto.setBizType(db.getBizType());
                Map httpParams = (Map)JSONObject.parseObject((String)db.getBizParams(), Map.class);
                dto.setHttpParams(httpParams);
                this.toDeveloper.asyncSubmit(db, dto, app);
            }
        }
        catch (Exception e) {
            this.log.error("OrderPushRetryJob error:", (Throwable)e);
        }
    }
}

