/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.orderstatus;

import cn.com.duiba.config.OrderStatusPushConfig;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.dao.HttpMessageDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.HttpMessageDO;
import cn.com.duiba.notifycenter.service.NotifyHttpClientPool;
import cn.com.duiba.service.HttpRetryRulesService;
import cn.com.duiba.service.ThreadPoolService;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import cn.com.duiba.thirdparty.dto.HttpResponseMessageDto;
import cn.com.duiba.tool.HttpRequestLog;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderStatusPushHttp {
    private static Logger logger = LoggerFactory.getLogger(OrderStatusPushHttp.class);
    @Autowired
    private HttpRetryRulesService httpRetryRulesService;
    @Autowired
    private AppDAO appDAO;
    @Autowired
    private HttpMessageDAO httpMessageDAO;
    @Autowired
    private ThreadPoolService threadPoolService;
    @Autowired
    private NotifyHttpClientPool notifyHttpClientPool;
    @Autowired
    private OrderStatusPushConfig orderStatusPushConfig;

    public void asyncSubmit(String message) {
        HttpRequestMessageDto dto = (HttpRequestMessageDto)JSONObject.parseObject((String)message, HttpRequestMessageDto.class);
        logger.info("\u8ba2\u5355\u63a8\u9001\u6570\u636e:{}", (Object)JSON.toJSONString((Object)dto));
        AppDO app = this.appDAO.findAppSimple(dto.getAppId());
        if (app == null) {
            logger.warn("appId:{} is empty", (Object)dto.getAppId());
            return;
        }
        HttpMessageDO hmd = new HttpMessageDO();
        hmd.setAppId(dto.getAppId());
        hmd.setBizType(dto.getBizType());
        hmd.setBizParams(JSONObject.toJSONString((Object)dto.getHttpParams()));
        hmd.setNumber(0);
        hmd.setOffset(this.httpRetryRulesService.getNextSecond(hmd));
        this.httpMessageDAO.insert(hmd);
        this.asyncSubmit(hmd, dto, app);
    }

    public void asyncSubmit(HttpMessageDO db, HttpRequestMessageDto msg2, AppDO app) {
        if (app == null) {
            return;
        }
        OrderStatusPushConfig.OrderStatusPushBean orderStatusPushBean = this.orderStatusPushConfig.getConfigMap().get(app.getId());
        if (orderStatusPushBean == null) {
            logger.info("appId:{} orderStatusPushBean is empty", (Object)app.getId());
        }
        String url = orderStatusPushBean.getPushUrl();
        Map map = msg2.getHttpParams();
        if (MapUtils.isEmpty((Map)map)) {
            return;
        }
        map.put("appKey", app.getAppKey());
        map.put("appSecret", this.appDAO.getAppSecret(app));
        String sign = SignTool.sign((Map)map);
        map.put("sign", sign);
        map.remove("appSecret");
        HttpPost httpPost = new HttpPost(url.trim());
        String paramsJsonStr = JSONObject.toJSONString((Object)map);
        logger.info("\u8ba2\u5355\u63a8\u9001 \u8bf7\u6c42url :{} \u8bf7\u6c42\u5165\u53c2:{}", (Object)url, (Object)paramsJsonStr);
        StringEntity body = new StringEntity(paramsJsonStr, "UTF-8");
        httpPost.setEntity((HttpEntity)body);
        httpPost.setHeader("Content-Type", "application/json; charset=UTF-8");
        HttpRequestLog.logUrl("[action orderStatusPush] [tag get request] [url " + url + "] [bizId " + (String)map.get("orderNum") + "][body " + paramsJsonStr + "]");
        this.submitReq(msg2, (HttpRequestBase)httpPost, db, url);
    }

    private void submitReq(final HttpRequestMessageDto msg2, HttpRequestBase http, final HttpMessageDO db, final String url) {
        this.notifyHttpClientPool.submit(msg2.getAppId(), (HttpUriRequest)http, new FutureCallback<HttpResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed(HttpResponse response) {
                HttpResponseMessageDto resp = new HttpResponseMessageDto();
                try {
                    String cont;
                    resp.setCallbackType("completed");
                    resp.setHttpUrl(url);
                    String body = EntityUtils.toString((HttpEntity)response.getEntity());
                    if (StringUtils.isNotEmpty((String)body) && (cont = body.toLowerCase()).contains("ok")) {
                        resp.setSuccess(Boolean.valueOf(true));
                    }
                    resp.setBody(HttpRequestLog.subBody(body));
                    resp.setBizId(msg2.getBizId());
                    resp.setBizType(msg2.getBizType());
                }
                catch (Exception e) {
                    resp.setSuccess(Boolean.valueOf(false));
                    resp.setErrorMessage("\u8bf7\u6c42\u5931\u8d25:completed:" + e.getMessage());
                    logger.error("completed param: {}", (Object)OrderStatusPushHttp.this.getCrecordParam(msg2), (Object)e);
                }
                finally {
                    OrderStatusPushHttp.this.httpRequestComleted(db, msg2, resp);
                }
            }

            public void failed(Exception ex) {
                logger.warn("orderStatusPush failed param: {}, errMsg: {}", new Object[]{OrderStatusPushHttp.this.getCrecordParam(msg2), OrderStatusPushHttp.this.getErrorMsg(ex), ex});
                HttpResponseMessageDto resp = new HttpResponseMessageDto();
                resp.setCallbackType("failed");
                resp.setHttpUrl(url);
                resp.setBizId(msg2.getBizId());
                resp.setBizType(msg2.getBizType());
                resp.setSuccess(Boolean.valueOf(false));
                resp.setErrorMessage("\u8bf7\u6c42\u5931\u8d25:failed:" + ex.getMessage());
                OrderStatusPushHttp.this.httpRequestComleted(db, msg2, resp);
            }

            public void cancelled() {
                logger.warn("orderStatusPush failed param:" + OrderStatusPushHttp.this.getCrecordParam(msg2));
                HttpResponseMessageDto resp = new HttpResponseMessageDto();
                resp.setCallbackType("cancelled");
                resp.setHttpUrl(url);
                resp.setBizId(msg2.getBizId());
                resp.setBizType(msg2.getBizType());
                resp.setSuccess(Boolean.valueOf(false));
                resp.setErrorMessage("\u8bf7\u6c42\u5931\u8d25:cancelled");
                OrderStatusPushHttp.this.httpRequestComleted(db, msg2, resp);
            }
        });
    }

    private String getErrorMsg(Exception ex) {
        String errMsg = ex.getMessage();
        if (ex.getCause() != null) {
            errMsg = ex.getCause().getMessage();
        }
        return errMsg;
    }

    private String getCrecordParam(HttpRequestMessageDto msg2) {
        return msg2.getHttpParams() != null ? JSONObject.toJSONString((Object)msg2.getHttpParams()) : "null";
    }

    private void httpRequestComleted(final HttpMessageDO db, HttpRequestMessageDto requestMessageDto, final HttpResponseMessageDto resp) {
        HttpRequestLog.logUrl("[action orderStatusPush Response][callback " + resp.getCallbackType() + "] [bizId " + (String)requestMessageDto.getHttpParams().get("orderNum") + "] [body " + resp.getBody() + "]");
        logger.info("\u8ba2\u5355\u63a8\u9001\u54cd\u5e94:{}", (Object)resp.getBody());
        this.threadPoolService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!"completed".equals(resp.getCallbackType()) || !"ok".equalsIgnoreCase(resp.getBody())) {
                        if (db.getNumber() >= OrderStatusPushHttp.this.httpRetryRulesService.getRetryNumber(db)) {
                            OrderStatusPushHttp.this.httpMessageDAO.delete(db.getId());
                            return;
                        }
                        OrderStatusPushHttp.this.httpMessageDAO.updateNextTime(db.getId(), OrderStatusPushHttp.this.httpRetryRulesService.getNextSecond(db));
                        return;
                    }
                    OrderStatusPushHttp.this.httpMessageDAO.delete(db.getId());
                }
                catch (Exception e) {
                    logger.error("httpRequestComleted", (Throwable)e);
                }
            }
        });
    }
}

