/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.remoteimpl.boc;

import cn.com.duiba.config.FuJianBocConfig;
import cn.com.duiba.thirdparty.api.boc.RemoteFjBocService;
import cn.com.duiba.thirdparty.dto.boc.IdentityDataDto;
import cn.com.duiba.thirdparty.dto.boc.LabelDataReqParam;
import cn.com.duiba.thirdparty.dto.boc.PublicDataReqParam;
import cn.com.duiba.thirdparty.dto.boc.UnionNoReqParam;
import cn.com.duiba.thirdparty.dto.boc.UserJoinActivityDataDto;
import cn.com.duiba.thirdparty.dto.boc.UserPvAndUvDataDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.boc.ConverTool;
import cn.com.duiba.tool.boc.SM3;
import cn.hutool.core.util.HexUtil;
import cn.hutool.crypto.BCUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.SM2;
import cn.hutool.crypto.digest.DigestAlgorithm;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteFjBocServiceImpl
implements RemoteFjBocService {
    private static Logger log = LoggerFactory.getLogger(RemoteFjBocServiceImpl.class);
    private static final String DUIBA_DATA_UPLOAD_PATH = "/unlogin/fjtj/duibaDataUpload";
    private static final String WX_DATA_URL_PATH = "/unlogin/fjtj/wxdata";
    private static final String LABEL_DATA_URL_PATH = "/unlogin/fjtj/labeldata";
    private static final String GET_UNION_ON_URL_PATH = "/unlogin/fjtj/getunionno";
    private static final String USER_LOG_URL_PATH = "/activitylogapi/userlog";
    private static final String ACTIVITY_LOG_URL_PATH = "/activitylogapi/activitylog";
    private static final int FIVE_SECONDS = 5000;
    private static final int TEN_SECONDS = 10000;
    private static final RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(10000).setConnectionRequestTimeout(500).build();
    @Resource
    private FuJianBocConfig fuJianBocConfig;
    @Resource(name="httpClient")
    private CloseableHttpClient httpClient;

    public JSONObject duibaDataUpload(List<IdentityDataDto> dataDtoList) throws IOException {
        List jsonObjectList = dataDtoList.stream().map(identityDataDto -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("openid", (Object)identityDataDto.getOpenId());
            jsonObject.put("mobile", (Object)identityDataDto.getMobile());
            jsonObject.put("union_no", (Object)identityDataDto.getUnionNo());
            return jsonObject;
        }).collect(Collectors.toList());
        JSONObject paramJsonObject = new JSONObject();
        paramJsonObject.put("datalist", jsonObjectList);
        paramJsonObject.put("appid", (Object)this.fuJianBocConfig.getAppId());
        paramJsonObject.put("appsecret", (Object)this.fuJianBocConfig.getAppSecret());
        String url = this.fuJianBocConfig.getUrl() + DUIBA_DATA_UPLOAD_PATH;
        String jsonStr = JSONObject.toJSONString((Object)paramJsonObject);
        log.info("\u798f\u5efa\u4e2d\u884c\u5b9e\u540d\u6570\u636e\u6279\u91cf\u4e0a\u9001,data:{}", (Object)jsonStr);
        JSONObject jsonObject = this.sendRequest(jsonStr, url, HttpMethod.POST);
        if (null == jsonObject) {
            return new JSONObject();
        }
        return this.assembleResult(jsonObject);
    }

    public JSONObject wxDataExport(PublicDataReqParam publicDataReqParam) throws IOException {
        publicDataReqParam.setAppid(this.fuJianBocConfig.getAppId());
        publicDataReqParam.setAppsecret(this.fuJianBocConfig.getAppSecret());
        String jsonStr = JSON.toJSONString((Object)publicDataReqParam);
        String url = this.fuJianBocConfig.getUrl() + WX_DATA_URL_PATH;
        JSONObject jsonObject = this.sendRequest(jsonStr, url, HttpMethod.POST);
        if (null == jsonObject) {
            return new JSONObject();
        }
        log.info("\u516c\u4f17\u53f7\u6570\u636e\u4e0a\u9001\u8bf7\u6c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)publicDataReqParam));
        return this.assembleResult(jsonObject);
    }

    public JSONObject labelDataExport(LabelDataReqParam dataRerParam) throws IOException {
        dataRerParam.setAppid(this.fuJianBocConfig.getAppId());
        dataRerParam.setAppsecret(this.fuJianBocConfig.getAppSecret());
        String jsonStr = JSON.toJSONString((Object)dataRerParam);
        String url = this.fuJianBocConfig.getUrl() + LABEL_DATA_URL_PATH;
        log.info("\u5916\u90e8\u7b2c\u4e09\u65b9\u6807\u7b7e\u6570\u636e\u4e0a\u9001\u8bf7\u6c42\u5165\u53c2");
        JSONObject jsonObject = this.sendRequest(jsonStr, url, HttpMethod.POST);
        if (null == jsonObject) {
            log.info("\u5916\u90e8\u7b2c\u4e09\u65b9\u6807\u7b7e\u6570\u636e\u4e0a\u9001\u8bf7\u6c42\u5165\u53c2\u8fd4\u56de\u4e3a\u7a7a");
            return new JSONObject();
        }
        log.info("\u5916\u90e8\u7b2c\u4e09\u65b9\u6807\u7b7e\u6570\u636e\u4e0a\u9001\u8bf7\u6c42\u5165\u53c2\u6210\u529f\uff1a{}", (Object)jsonObject.getString("msgcode"));
        return this.assembleResult(jsonObject);
    }

    public JSONObject getUnionNo(UnionNoReqParam reqParam) throws IOException {
        String url;
        String jsonStr = JSON.toJSONString((Object)reqParam);
        JSONObject jsonObject = this.sendRequest(jsonStr, url = this.fuJianBocConfig.getUrl() + GET_UNION_ON_URL_PATH, HttpMethod.POST);
        if (null == jsonObject) {
            return new JSONObject();
        }
        return this.assembleResult(jsonObject);
    }

    public String verifyUser(String openId) {
        String s = Base64.getEncoder().encodeToString(openId.getBytes());
        return this.fuJianBocConfig.getVerifyUserUrl() + "?openid=" + s;
    }

    public JSONObject sendUserJoinActivityDailyData(List<UserJoinActivityDataDto> userJoinActivityDataList) {
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("appkey", this.fuJianBocConfig.getWeChatAppKey());
        paramMap.put("appsecret", this.fuJianBocConfig.getWeChatAppSecret());
        paramMap.put("datalist", JSONObject.toJSONString(userJoinActivityDataList));
        paramMap.put("timestamp", System.currentTimeMillis());
        String sign = SecureUtil.signParams((DigestAlgorithm)DigestAlgorithm.MD5, (Map)paramMap, (String)"&", (String)"=", (boolean)true, (String[])new String[0]);
        paramMap.put("sign", sign);
        paramMap.remove("appsecret");
        String urlPath = this.fuJianBocConfig.getWeChatUrl() + USER_LOG_URL_PATH;
        HttpPost httpPost = new HttpPost(urlPath);
        httpPost.setConfig(requestConfig);
        StringEntity se = new StringEntity(JSONObject.toJSONString((Object)paramMap), "utf-8");
        httpPost.setHeader("Content-Type", "application/json; charset=UTF-8");
        log.info("\u798f\u5efa\u4e2d\u884c\u6bcf\u65e5\u7528\u6237\u6570\u636e\u4e0a\u9001\u8bf7\u6c42\uff0crequestUrl\uff1a{}\uff0cparams\uff1a{}", (Object)urlPath, (Object)JSONObject.toJSONString((Object)paramMap));
        httpPost.setEntity((HttpEntity)se);
        String res = this.fjBocRequest((HttpUriRequest)httpPost);
        return JSONObject.parseObject((String)res);
    }

    public JSONObject sendUserPvAndUvDailyData(List<UserPvAndUvDataDto> userPvAndUvDataList) {
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("appkey", this.fuJianBocConfig.getWeChatAppKey());
        paramMap.put("appsecret", this.fuJianBocConfig.getWeChatAppSecret());
        paramMap.put("datalist", JSONObject.toJSONString(userPvAndUvDataList));
        paramMap.put("timestamp", System.currentTimeMillis());
        String sign = SecureUtil.signParams((DigestAlgorithm)DigestAlgorithm.MD5, (Map)paramMap, (String)"&", (String)"=", (boolean)true, (String[])new String[0]);
        paramMap.put("sign", sign);
        paramMap.remove("appsecret");
        String urlPath = this.fuJianBocConfig.getWeChatUrl() + ACTIVITY_LOG_URL_PATH;
        HttpPost httpPost = new HttpPost(urlPath);
        httpPost.setConfig(requestConfig);
        StringEntity se = new StringEntity(JSONObject.toJSONString((Object)paramMap), "utf-8");
        httpPost.setHeader("Content-Type", "application/json; charset=UTF-8");
        log.info("\u798f\u5efa\u4e2d\u884c\u6d3b\u52a8PV/UV\u6570\u636e\u4e0a\u9001\u8bf7\u6c42\uff0crequestUrl\uff1a{}\uff0cparams\uff1a{}", (Object)urlPath, (Object)JSONObject.toJSONString((Object)paramMap));
        httpPost.setEntity((HttpEntity)se);
        String res = this.fjBocRequest((HttpUriRequest)httpPost);
        return JSONObject.parseObject((String)res);
    }

    private JSONObject sendRequest(String jsonStr, String urlPath, HttpMethod httpMethod) throws IOException {
        byte[] dataBytes = jsonStr.getBytes("UTF-8");
        String encResultData = this.getEncResultData(dataBytes);
        String signatureSign = this.getSignatureSign(dataBytes);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("encresult", (Object)encResultData);
        jsonObject.put("signdata", (Object)signatureSign);
        Map params = (Map)JSONObject.parseObject((String)jsonObject.toJSONString(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        String res = "";
        if (httpMethod == HttpMethod.POST) {
            HttpPost httpPost = new HttpPost(urlPath);
            httpPost.setConfig(requestConfig);
            StringEntity se = new StringEntity(JSONObject.toJSONString((Object)params), "utf-8");
            httpPost.setHeader("Content-Type", "application/json; charset=UTF-8");
            log.info("\u798f\u5efa\u4e2d\u884c\u8bf7\u6c42\uff0crequestUrl\uff1a{},jsonStr:{}", (Object)urlPath, (Object)jsonStr);
            httpPost.setEntity((HttpEntity)se);
            res = this.fjBocRequest((HttpUriRequest)httpPost);
        } else {
            String assembleUrl = AssembleTool.assembleUrl(urlPath, params);
            log.info("\u798f\u5efa\u4e2d\u884c-\u8bf7\u6c42url\uff0curl:{},jsonstr:{}", (Object)assembleUrl, (Object)jsonStr);
            HttpGet httpGet = new HttpGet(assembleUrl);
            httpGet.setConfig(requestConfig);
            res = this.fjBocRequest((HttpUriRequest)httpGet);
        }
        log.info("\u798f\u5efa\u4e2d\u884c\u8bf7\u6c42\u7ed3\u679c\uff0cres\uff1a{}", (Object)res);
        return JSONObject.parseObject((String)res);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String fjBocRequest(HttpUriRequest httpRequest) {
        try (CloseableHttpResponse response = this.httpClient.execute(httpRequest);){
            String responseStr;
            String string = responseStr = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
        catch (Exception e) {
            log.warn("\u798f\u5efa\u4e2d\u884c\u54cd\u5e94\u5f02\u5e38\uff0curl:{}", (Object)httpRequest.getURI().getPath(), (Object)e);
            return null;
        }
    }

    private String getEncResultData(byte[] dataBytes) {
        String shPublicKey = this.fuJianBocConfig.getSHPublicKey();
        if (shPublicKey.length() == 130) {
            shPublicKey = shPublicKey.substring(2);
        }
        String shxHex = shPublicKey.substring(0, 64);
        String shhyHex = shPublicKey.substring(64, 128);
        ECPublicKeyParameters ecPublicKeyParameters = BCUtil.toSm2Params((String)shxHex, (String)shhyHex);
        SM2 sm2 = new SM2(null, ecPublicKeyParameters);
        sm2.usePlainEncoding();
        sm2.setMode(SM2Engine.Mode.C1C2C3);
        byte[] encData = sm2.encrypt(dataBytes, KeyType.PublicKey);
        return ConverTool.parseByte2HexStr(encData);
    }

    private String getSignatureSign(byte[] dataBytes) throws IOException {
        String sm2SignTextData = SM3.byteArrayToHexString(SM3.hash(dataBytes)) + this.fuJianBocConfig.getAppId();
        byte[] sm2SignDataBytesData = sm2SignTextData.getBytes("UTF-8");
        ECPrivateKeyParameters privateKeyParameters = BCUtil.toSm2Params((String)this.fuJianBocConfig.getPTPrivateKeyHex());
        SM2 sm22 = new SM2(privateKeyParameters, null);
        sm22.usePlainEncoding();
        sm22.setMode(SM2Engine.Mode.C1C2C3);
        byte[] sign = sm22.sign(sm2SignDataBytesData, null);
        return HexUtil.encodeHexStr((byte[])sign);
    }

    private String decodeResult(String encResultData) throws UnsupportedEncodingException {
        ECPrivateKeyParameters ecPrivateKeyParameters = BCUtil.toSm2Params((String)this.fuJianBocConfig.getPTPrivateKeyHex());
        SM2 sm2pri = new SM2(ecPrivateKeyParameters, null);
        sm2pri.usePlainEncoding();
        sm2pri.setMode(SM2Engine.Mode.C1C2C3);
        byte[] decdata = sm2pri.decrypt(ConverTool.parseHexStr2Byte(encResultData), KeyType.PrivateKey);
        return new String(decdata, "UTF-8");
    }

    private boolean verifyResult(String decodeBody, String signatureSign) throws IOException {
        String shPublicKey = this.fuJianBocConfig.getSHPublicKey();
        if (shPublicKey.length() == 130) {
            shPublicKey = shPublicKey.substring(2);
        }
        String xhex = shPublicKey.substring(0, 64);
        String yhex = shPublicKey.substring(64, 128);
        ECPublicKeyParameters params = BCUtil.toSm2Params((String)xhex, (String)yhex);
        SM2 sm2b = new SM2(null, params);
        sm2b.usePlainEncoding();
        sm2b.setMode(SM2Engine.Mode.C1C2C3);
        String sm2signtext = SM3.byteArrayToHexString(SM3.hash(decodeBody.getBytes("UTF-8"))) + this.fuJianBocConfig.getSignInfo();
        byte[] sm2signdataBytes = sm2signtext.getBytes("UTF-8");
        return sm2b.verify(sm2signdataBytes, HexUtil.decodeHex((String)signatureSign));
    }

    private JSONObject assembleResult(JSONObject jsonObject) throws IOException {
        JSONObject result = new JSONObject();
        String decodeBody = "";
        if (!"0000".equals(jsonObject.getString("msgcde"))) {
            return jsonObject;
        }
        if (!jsonObject.containsKey((Object)"signdata")) {
            return jsonObject;
        }
        if (jsonObject.containsKey((Object)"encresult")) {
            String encresult = jsonObject.getString("encresult");
            decodeBody = this.decodeResult(encresult);
            result = JSON.parseObject((String)decodeBody);
            result.put("msgcde", (Object)jsonObject.getString("msgcde"));
        }
        if (StringUtils.isBlank((CharSequence)decodeBody) || !this.verifyResult(decodeBody, jsonObject.getString("signdata"))) {
            log.error("\u9a8c\u7b7e\u5931\u8d25");
            jsonObject.put("msgcode", (Object)"E0S");
            jsonObject.put("msg", (Object)"\u9a8c\u7b7e\u5931\u8d25,\u7b7e\u540d\u6570\u636e\u9519\u8bef");
            return jsonObject;
        }
        return result;
    }
}

