/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.impl;

import cn.com.duiba.domain.RequestTypeEnum;
import cn.com.duiba.mq.RocketMQMsgProducer;
import cn.com.duiba.mq.RocketMqTopicManager;
import cn.com.duiba.service.DuibaVirtualSupplier;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.thirdparty.dto.SupplierRequestDto;
import cn.com.duiba.thirdparty.dto.SupplierResponseDto;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractDuibaVirtualSupplier
implements DuibaVirtualSupplier {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDuibaVirtualSupplier.class);
    private static final String OK = "ok";
    private static final String FAIL = "fail";
    private static final String PROCESS = "process";
    private static final String STATUS = "status";
    @Autowired
    protected RocketMqTopicManager rocketMqTopicManager;
    @Autowired
    private RocketMQMsgProducer rocketProducer;
    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;

    public void sendResponse(SupplierResponseDto supplierResponseDto) {
        LOGGER.info("\u53d1\u9001\u4f9b\u5e94\u5546\u56de\u8c03\u4fe1\u606f,message:{},topic:{}", (Object)JSONObject.toJSONString((Object)supplierResponseDto), (Object)this.rocketMqTopicManager.getDuibaVirtualNotifyTopic());
        this.rocketProducer.sendMsg(this.rocketMqTopicManager.getDuibaVirtualNotifyTopic(), "duiba-virtual", null, JSONObject.toJSONString((Object)supplierResponseDto), false, null);
    }

    public static SupplierResponseDto getSupplierResponse(SupplierRequestDto request) {
        SupplierResponseDto response = new SupplierResponseDto();
        response.setCallbackType("completed");
        response.setSupplierName("duiba-virtual");
        response.setOrderId(request.getOrderId());
        response.setAppId(request.getAppId());
        response.setConsumerId(request.getConsumerId());
        response.setSupplierOrderId(request.getSupplierOrderId());
        return response;
    }

    public static void setResponse(SupplierResponseDto response, boolean success, String desc) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(STATUS, success ? OK : FAIL);
        if (StringUtils.isNotBlank((CharSequence)desc)) {
            response.setErrorMessage(desc);
        }
        response.setBody(JSONObject.toJSONString(map));
    }

    @Override
    public void submit(final SupplierRequestDto request) {
        HttpRequestBase requestBase = null;
        try {
            requestBase = this.getVirtualRequest(request);
        }
        catch (Exception ex) {
            SupplierResponseDto resp = (SupplierResponseDto)BeanUtils.copy((Object)request, SupplierResponseDto.class);
            resp.setCallbackType("failed");
            resp.setError4Consumer(this.getDefaultError4ConsumerMessage());
            resp.setErrorMessage(ex.getClass().getName() + ":" + ex.getMessage());
            this.finallySendMessage(request, resp);
            return;
        }
        this.httpAsyncClientPool.submit(request.getAppId(), (HttpUriRequest)requestBase, new FutureCallback<HttpResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed(HttpResponse response) {
                SupplierResponseDto resp = new SupplierResponseDto();
                try {
                    resp.setOrderId(request.getOrderId());
                    resp.setSupplierOrderId(request.getSupplierOrderId());
                    resp.setSupplierName(request.getSupplierName());
                    resp.setUrl(request.getHttpUrl());
                    resp.setCallbackType("completed");
                    resp.setAppId(request.getAppId());
                    resp.setConsumerId(request.getConsumerId());
                    String result = AbstractDuibaVirtualSupplier.this.parseResponseResult(response);
                    String body = AbstractDuibaVirtualSupplier.this.getVirtualResponse(request, result);
                    AbstractDuibaVirtualSupplier.this.parseBody(body, resp);
                    resp.setBody(HttpRequestLog.subBody(body));
                }
                catch (Exception e) {
                    LOGGER.error(this.getClass().getName() + ".completed exception", (Throwable)e);
                }
                finally {
                    AbstractDuibaVirtualSupplier.this.finallySendMessage(request, resp);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void failed(Exception ex) {
                LOGGER.error(this.getClass().getName() + ".failed,orderId:" + request.getOrderId(), (Throwable)ex);
                SupplierResponseDto resp = new SupplierResponseDto();
                try {
                    resp.setOrderId(request.getOrderId());
                    resp.setSupplierOrderId(request.getSupplierOrderId());
                    resp.setCallbackType("failed");
                    resp.setAppId(request.getAppId());
                    resp.setConsumerId(request.getConsumerId());
                    resp.setError4Consumer(AbstractDuibaVirtualSupplier.this.getDefaultError4ConsumerMessage());
                    resp.setErrorMessage(ex.getClass().getName() + ":" + ex.getMessage());
                }
                catch (Exception e) {
                    LOGGER.error(this.getClass().getName() + ".failed", (Throwable)e);
                }
                finally {
                    AbstractDuibaVirtualSupplier.this.finallySendMessage(request, resp);
                }
            }

            public void cancelled() {
                LOGGER.warn(this.getClass().getName() + ".cancelled,orderId:{}", (Object)request.getOrderId());
                SupplierResponseDto resp = new SupplierResponseDto();
                try {
                    resp.setOrderId(request.getOrderId());
                    resp.setSupplierOrderId(request.getSupplierOrderId());
                    resp.setCallbackType("cancelled");
                    resp.setAppId(request.getAppId());
                    resp.setConsumerId(request.getConsumerId());
                }
                catch (Exception e) {
                    LOGGER.error(this.getClass().getName() + ".cancelled", (Throwable)e);
                }
                finally {
                    AbstractDuibaVirtualSupplier.this.finallySendMessage(request, resp);
                }
            }
        }, RequestTypeEnum.VIRTUAL);
    }

    private void finallySendMessage(SupplierRequestDto supplierRequest, SupplierResponseDto supplierResponse) {
        this.sendResponse(supplierResponse);
    }

    private String parseResponseResult(HttpResponse response) throws IOException {
        Header header = response.getEntity().getContentEncoding();
        String result = header != null && header.toString().contains("gzip") ? EntityUtils.toString((HttpEntity)new GzipDecompressingEntity(response.getEntity())) : EntityUtils.toString((HttpEntity)response.getEntity());
        return result;
    }

    private void parseBody(String body, SupplierResponseDto resp) {
        if (StringUtils.isBlank((CharSequence)body)) {
            return;
        }
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)body);
            String statusStr = jsonObject.getString(STATUS);
            if (FAIL.equalsIgnoreCase(statusStr)) {
                resp.setError4Consumer(this.getDefaultError4ConsumerMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error("json exception:{}", (Object)body);
        }
    }
}

