/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.impl;

import cn.com.duiba.api.bo.mq.EmailMsg;
import cn.com.duiba.service.EmailService;
import cn.com.duibabiz.component.email.DuibaEmailProperties;
import java.util.concurrent.ExecutorService;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;

@Service
public class EmailServiceImpl
implements EmailService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailServiceImpl.class);
    @Autowired
    private JavaMailSender javaMailSender;
    @Autowired
    private ExecutorService executorService;
    @Autowired
    private DuibaEmailProperties duibaEmailProperties;

    @Override
    public void sendEmail(EmailMsg emailMsg) {
        this.executorService.execute(() -> {
            try {
                MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
                MimeMessageHelper helper = new MimeMessageHelper(mimeMessage);
                helper.setTo(emailMsg.getReceiver());
                helper.setSubject(emailMsg.getSubject());
                helper.setFrom(this.duibaEmailProperties.getUsername());
                helper.setText(emailMsg.getHtml(), true);
                this.javaMailSender.send(mimeMessage);
            }
            catch (Exception e) {
                LOGGER.error("sendEmail failed, receiver={}, subject={}", new Object[]{emailMsg.getReceiver(), emailMsg.getSubject(), e});
            }
        });
    }
}

