/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.virtual.impl;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.config.PuShangConfig;
import cn.com.duiba.service.impl.AbstractDuibaVirtualSupplier;
import cn.com.duiba.service.virtual.impl.dto.PuShangResponse;
import cn.com.duiba.service.virtual.impl.dto.pushang.CommonResponse;
import cn.com.duiba.thirdparty.dto.SupplierRequestDto;
import cn.com.duiba.thirdparty.enums.virtual.VirtualItemChannelEnum;
import cn.com.duiba.tool.MD5;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PuShangApiStrategy
extends AbstractDuibaVirtualSupplier
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(PuShangApiStrategy.class);
    private static final String LOGGER_PREFIX = "\u6d66\u4e0a\u865a\u62df\u5546\u54c1\u5bf9\u63a5";
    private static final Long SUCCESS = 0L;
    private static final Long FAIL = 1L;
    @Autowired
    private PuShangConfig puShangConfig;
    private Map<String, Function<SupplierRequestDto, HttpRequestBase>> functionMap = Maps.newHashMap();
    private Map<String, Function<CommonResponse, String>> responseFunctionMap = Maps.newHashMap();
    private static final String Error4ConsumerMessage = "\u51fa\u4e86\u70b9\u5c0f\u95ee\u9898\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355";

    public void afterPropertiesSet() throws Exception {
        this.functionMap.put("11", this::getTianMaoRequest);
        this.functionMap.put("14", this::getNaiXueRequest);
        this.functionMap.put("17", this::getZFBRequest);
        this.functionMap.put("6", this::getVideoRequest);
        this.responseFunctionMap.put("11", this::commonResponse);
        this.responseFunctionMap.put("14", this::commonResponse);
        this.responseFunctionMap.put("17", this::commonResponse);
        this.responseFunctionMap.put("6", this::commonResponse);
    }

    private HttpRequestBase getTianMaoRequest(SupplierRequestDto request) {
        Map stringMap = request.getParams();
        String bizParams = (String)stringMap.get("bizParams");
        String productId = bizParams.split("-")[1];
        String buyerNick = (String)stringMap.get("account");
        String extOrderId = (String)stringMap.get("orderNum");
        String notifyUrl = this.puShangConfig.getNotifyUrl();
        String merchantId = this.puShangConfig.getMerchantId();
        String md5MerchantId = this.puShangConfig.getMd5MerchantId();
        String sourceSign = buyerNick + extOrderId + merchantId + notifyUrl + productId + md5MerchantId;
        String sign = "";
        try {
            sign = MD5.md5(sourceSign.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("\u52a0\u7b7e\u5931\u8d25 request = {}", (Object)JSON.toJSONString((Object)request));
        }
        HashMap params = Maps.newHashMap();
        params.put("productId", productId);
        params.put("buyerNick", buyerNick);
        params.put("extOrderId", extOrderId);
        params.put("notifyUrl", notifyUrl);
        params.put("merchantId", merchantId);
        params.put("sign", sign);
        HttpPost httpPost = new HttpPost("http://api.yaajie.com:8080/api/tianMao/makeOrder?productId=" + productId + "&buyerNick=" + buyerNick + "&extOrderId=" + extOrderId + "&notifyUrl=" + notifyUrl + "&merchantId=" + merchantId + "&sign=" + sign);
        httpPost.setEntity((HttpEntity)new StringEntity(JSON.toJSONString((Object)params), ContentType.APPLICATION_FORM_URLENCODED));
        return httpPost;
    }

    private HttpRequestBase getNaiXueRequest(SupplierRequestDto request) {
        Map stringMap = request.getParams();
        String bizParams = (String)stringMap.get("bizParams");
        String productId = bizParams.split("-")[1];
        String buyerNick = (String)stringMap.get("account");
        String extOrderId = (String)stringMap.get("orderNum");
        String notifyUrl = this.puShangConfig.getNotifyUrl();
        String merchantId = this.puShangConfig.getMerchantId();
        String md5MerchantId = this.puShangConfig.getMd5MerchantId();
        String sourceSign = buyerNick + productId + extOrderId + merchantId + notifyUrl + md5MerchantId;
        String sign = "";
        try {
            sign = MD5.md5(sourceSign.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("\u52a0\u7b7e\u5931\u8d25 request = {}", (Object)JSON.toJSONString((Object)request));
        }
        HashMap params = Maps.newHashMap();
        params.put("productId", productId);
        params.put("merchantId", merchantId);
        params.put("extOrderId", extOrderId);
        params.put("notifyUrl", notifyUrl);
        params.put("phoneNumber", buyerNick);
        params.put("sign", sign);
        HttpPost httpPost = new HttpPost("http://api.yaajie.com:8080/api/naiXue/makeOrder?productId=" + productId + "&merchantId=" + merchantId + "&phoneNumber=" + buyerNick + "&extOrderId=" + extOrderId + "&notifyUrl=" + notifyUrl + "&sign=" + sign);
        httpPost.setEntity((HttpEntity)new StringEntity(JSON.toJSONString((Object)params), ContentType.APPLICATION_FORM_URLENCODED));
        return httpPost;
    }

    private HttpRequestBase getZFBRequest(SupplierRequestDto request) {
        Map stringMap = request.getParams();
        String bizParams = (String)stringMap.get("bizParams");
        String productId = bizParams.split("-")[1];
        String buyerNick = (String)stringMap.get("account");
        String extOrderId = (String)stringMap.get("orderNum");
        String notifyUrl = this.puShangConfig.getNotifyUrl();
        String merchantId = this.puShangConfig.getMerchantId();
        String md5MerchantId = this.puShangConfig.getMd5MerchantId();
        String sourceSign = extOrderId + buyerNick + merchantId + productId + notifyUrl + md5MerchantId;
        String sign = "";
        try {
            sign = MD5.md5(sourceSign.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("\u52a0\u7b7e\u5931\u8d25 request = {}", (Object)JSON.toJSONString((Object)request));
        }
        HashMap params = Maps.newHashMap();
        params.put("extOrderId", extOrderId);
        params.put("incomeAccount", buyerNick);
        params.put("merchantId", merchantId);
        params.put("productId", productId);
        params.put("notifyUrl", notifyUrl);
        params.put("incomeRemark", "");
        params.put("incomeUserName", "");
        params.put("sign", sign);
        HttpPost httpPost = new HttpPost("http://api.yaajie.com:8080/api/zfb/act/makeOrder?extOrderId=" + extOrderId + "&incomeAccount=" + buyerNick + "&merchantId=" + merchantId + "&productId=" + productId + "&notifyUrl=" + notifyUrl + "&sign=" + sign + "&incomeRemark=&incomeUserName=");
        httpPost.setEntity((HttpEntity)new StringEntity(JSON.toJSONString((Object)params), ContentType.APPLICATION_FORM_URLENCODED));
        return httpPost;
    }

    private HttpRequestBase getVideoRequest(SupplierRequestDto request) {
        Map stringMap = request.getParams();
        String bizParams = (String)stringMap.get("bizParams");
        String productId = bizParams.split("-")[1];
        String buyerNick = (String)stringMap.get("account");
        String extOrderId = (String)stringMap.get("orderNum");
        String notifyUrl = this.puShangConfig.getNotifyUrl();
        String merchantId = this.puShangConfig.getMerchantId();
        String md5MerchantId = this.puShangConfig.getMd5MerchantId();
        String sourceSign = buyerNick + extOrderId + merchantId + notifyUrl + NumberUtils.LONG_ONE + productId + md5MerchantId;
        String sign = "";
        try {
            sign = MD5.md5(sourceSign.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("\u52a0\u7b7e\u5931\u8d25 request = {}", (Object)JSON.toJSONString((Object)request));
        }
        HashMap params = Maps.newHashMap();
        params.put("productId", productId);
        params.put("merchantId", merchantId);
        params.put("extOrderId", extOrderId);
        params.put("notifyUrl", notifyUrl);
        params.put("account", buyerNick);
        params.put("number", NumberUtils.INTEGER_ONE.toString());
        params.put("sign", sign);
        HttpPost httpPost = new HttpPost("http://api.yaajie.com:8080/api/video/makeOrder?merchantId=" + merchantId + "&extOrderId=" + extOrderId + "&productId=" + productId + "&account=" + buyerNick + "&number=" + NumberUtils.LONG_ONE + "&notifyUrl=" + notifyUrl + "&sign=" + sign);
        httpPost.setEntity((HttpEntity)new StringEntity(JSON.toJSONString((Object)params), ContentType.APPLICATION_FORM_URLENCODED));
        return httpPost;
    }

    @Override
    public HttpRequestBase getVirtualRequest(SupplierRequestDto request) {
        Map originData = request.getParams();
        String bizParams = (String)originData.get("bizParams");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)bizParams)) {
            throw new ThirdpatyException("\u53c2\u6570\u9519\u8bef\uff0c\u6ca1\u6709\u5bf9\u5e94\u7684\u5546\u54c1\u4fe1\u606f");
        }
        if (StringUtils.isEmpty(originData.get("account"))) {
            throw new ThirdpatyException("\u624b\u673a\u53f7\u4fe1\u606f\u5fc5\u586b");
        }
        String type = Arrays.stream(bizParams.split("-")).findFirst().orElse("");
        Function<SupplierRequestDto, HttpRequestBase> function = this.functionMap.get(type);
        if (Objects.isNull(function)) {
            throw new ThirdpatyException("\u8c03\u7528\u65b9\u6cd5\u5f02\u5e38");
        }
        HttpRequestBase httpRequestBase = function.apply(request);
        log.info("puShang \u63a5\u53e3\u8bf7\u6c42 httpRequestBase = {}", (Object)JSONUtil.toJsonStr((Object)httpRequestBase));
        return httpRequestBase;
    }

    @Override
    public String getVirtualResponse(SupplierRequestDto request, String body) {
        Map originData = request.getParams();
        String bizParams = (String)originData.get("bizParams");
        String type = Arrays.stream(bizParams.split("-")).findFirst().orElse("");
        Function<CommonResponse, String> function = this.responseFunctionMap.get(type);
        if (Objects.isNull(function)) {
            throw new ThirdpatyException("\u8c03\u7528\u65b9\u6cd5\u5f02\u5e38");
        }
        return function.apply(new CommonResponse(request, body));
    }

    private String commonResponse(CommonResponse commonResponse) {
        String body = commonResponse.getBody();
        SupplierRequestDto request = commonResponse.getRequest();
        HashMap duibaDoc = Maps.newHashMap();
        if (StringUtils.isEmpty((Object)body)) {
            log.error("\u6d66\u4e0a\u865a\u62df\u5546\u54c1\u5bf9\u63a5\u8bf7\u6c42\u4e0b\u5355\u5931\u8d25\uff01\u8bf7\u6c42\u8ba2\u5355Id:{},\u8fd4\u56de\u7684response\u89e3\u6790\u4e3a\u7a7a", (Object)request.getOrderId());
            duibaDoc.put("status", "fail");
            return JSONObject.toJSONString((Object)duibaDoc);
        }
        PuShangResponse puShangResponse = (PuShangResponse)JSON.parseObject((String)body, PuShangResponse.class);
        if (SUCCESS.equals(puShangResponse.getCode())) {
            log.info("\u6d66\u4e0a\u865a\u62df\u5546\u54c1\u5bf9\u63a5\u8bf7\u6c42\u4e0b\u5355\u6210\u529f\uff01\u8bf7\u6c42\u8ba2\u5355Id:{},response={}", (Object)request.getOrderId(), (Object)JSONObject.toJSONString((Object)puShangResponse));
            duibaDoc.put("status", "process");
            return JSONObject.toJSONString((Object)duibaDoc);
        }
        if (FAIL.equals(puShangResponse.getCode())) {
            log.info("\u6d66\u4e0a\u865a\u62df\u5546\u54c1\u5bf9\u63a5\u8bf7\u6c42\u4e0b\u5355\u5931\u8d25\uff01\u8bf7\u6c42\u8ba2\u5355Id:{},\u5931\u8d25\u539f\u56e0\u662f:{}", (Object)request.getOrderId(), (Object)puShangResponse.getMsg());
            duibaDoc.put("status", "fail");
            return JSONObject.toJSONString((Object)duibaDoc);
        }
        log.error("\u6d66\u4e0a\u865a\u62df\u5546\u54c1\u5bf9\u63a5\u8bf7\u6c42\u4e0b\u5355\u5931\u8d25\uff01\u51fa\u73b0\u672a\u77e5\u56de\u590d,\u8bf7\u6c42\u8ba2\u5355Id:{},response={}", (Object)request.getOrderId(), (Object)JSONObject.toJSONString((Object)puShangResponse));
        duibaDoc.put("status", "fail");
        return JSONObject.toJSONString((Object)duibaDoc);
    }

    @Override
    public String getVirtualTypeCode() {
        return VirtualItemChannelEnum.PU_SHANG.getCode();
    }

    @Override
    public String getDefaultError4ConsumerMessage() {
        return Error4ConsumerMessage;
    }
}

