/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool.huawei;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class UrlUtils {
    public static Map<String, String> extractUrlParamsFromUrl(String url) {
        String queryString = UrlUtils.truncateQueryString(url);
        if (queryString == null) {
            return Collections.emptyMap();
        }
        return UrlUtils.extractUrlParams(queryString);
    }

    public static Map<String, String> extractUrlParams(String queryString) {
        String[] arrSplit;
        if (StringUtils.isBlank((String)queryString)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> mapRequest = new HashMap<String, String>();
        for (String strSplit : arrSplit = StringUtils.split((String)queryString, (char)'&')) {
            String[] arrSplitEqual = StringUtils.split((String)strSplit, (char)'=');
            if (arrSplitEqual.length > 1) {
                try {
                    mapRequest.put(arrSplitEqual[0], URLDecoder.decode(arrSplitEqual[1], StandardCharsets.UTF_8.name()));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException(e);
                }
            }
            if (arrSplitEqual[0].equals("")) continue;
            mapRequest.put(arrSplitEqual[0], "");
        }
        return mapRequest;
    }

    private static String truncateQueryString(String strURL) {
        String url = StringUtils.trimToEmpty((String)strURL);
        int idx = url.indexOf(63);
        if (idx == -1) {
            return null;
        }
        return url.substring(idx + 1);
    }
}

