/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool.hzunitebank;

import com.alibaba.fastjson.JSON;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

public class RSAUtils {
    protected static byte[] resultBytes;
    public static final int keysize_1024 = 1024;
    public static final int keysize_2048 = 2048;
    public static final String Public_Key = "publicKey";
    public static final String Private_Key = "privateKey";
    public static final String KEY_ALGORITHM = "RSA";
    public static final String SIGNATURE_ALGORITHM = "SHA256withRSA";

    public static Map createPubKeyAndPriKey(int keysize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyPairGen.initialize(keysize);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(Private_Key, RSAUtils.getKeyString(privateKey));
        map.put(Public_Key, RSAUtils.getKeyString(publicKey));
        return map;
    }

    private static String getKeyString(Key key) {
        byte[] keyBytes = key.getEncoded();
        return new Base64().encodeToString(keyBytes);
    }

    private static PublicKey getPublicKey(String key) throws Exception {
        byte[] keyBytes = new Base64().decode(key);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        return publicKey;
    }

    private static PrivateKey getPrivateKey(String key) throws Exception {
        byte[] keyBytes = new Base64().decode(key);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        return privateKey;
    }

    public static String encrypt(String publicKey, String enStr) throws Exception {
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(1, RSAUtils.getPublicKey(publicKey));
        byte[] resultBytes = cipher.doFinal(enStr.getBytes());
        return Base64.encodeBase64String((byte[])resultBytes);
    }

    public static String decrypt(String privateKey, String deStr) throws Exception {
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(2, RSAUtils.getPrivateKey(privateKey));
        byte[] decBytes = cipher.doFinal(Base64.decodeBase64((String)deStr));
        return new String(decBytes);
    }

    public static String sign(String privateKey, String data) {
        try {
            PrivateKey privateK = RSAUtils.getPrivateKey(privateKey);
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            signature.initSign(privateK);
            signature.update(data.getBytes("utf-8"));
            return Base64.encodeBase64String((byte[])signature.sign());
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String sign(String privateKey, String data, String type) throws Exception {
        PrivateKey privateK = RSAUtils.getPrivateKey(privateKey);
        Signature signature = Signature.getInstance(type);
        signature.initSign(privateK);
        signature.update(data.getBytes());
        return Base64.encodeBase64String((byte[])signature.sign());
    }

    public static byte[] signGetByte(String privateKey, String data) throws Exception {
        PrivateKey privateK = RSAUtils.getPrivateKey(privateKey);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(privateK);
        signature.update(data.getBytes());
        return signature.sign();
    }

    public static boolean verify(String data, String publicKey, String sign) throws Exception {
        PublicKey publicK = RSAUtils.getPublicKey(publicKey);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initVerify(publicK);
        signature.update(data.getBytes());
        return signature.verify(Base64.decodeBase64((String)sign));
    }

    public static boolean verify(String data, String publicKey, String sign, String type) throws Exception {
        PublicKey publicK = RSAUtils.getPublicKey(publicKey);
        Signature signature = Signature.getInstance(type);
        signature.initVerify(publicK);
        signature.update(data.getBytes());
        return signature.verify(Base64.decodeBase64((String)sign));
    }

    public static void main(String[] args) throws Exception {
        System.out.println(JSON.toJSONString((Object)RSAUtils.createPubKeyAndPriKey(2048)));
    }
}

