package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.constant.ErweihuoConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.ErweihuoRopUtils;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.Map;

/**
 * @author JunAngLiu
 * @Title: ErweihuoApi
 * @Description: 二维火
 * @date 2019/10/914:29
 */
@Service
public class ErweihuoApi {

    private static final Logger LOGGER = LoggerFactory.getLogger(ErweihuoApi.class);

    //语言参数
    private static final String LANGUAGE = "zh_CN";

    private static final String DELIMITER = "?";


    @Autowired
    private ErweihuoConfig erweihuoConfig;



    /**
     * 判断当前app是否是 二维火的app
     * @param appId
     * @return
     */
    public boolean isErweihuo(Long appId){

        return  appId != null && erweihuoConfig.getAppIds() != null && erweihuoConfig.getAppIds().contains(appId);
    }


    /**
     * 扣积分 参数构造
     * @param request
     * @return
     */
    public SubCreditsMsgWrapper getSubCredits(SubCreditsMsgWrapper request) {
        try{
            String url = request.getHttpUrl();
            String host = this.getGateway(url);
            // 取出原始参数/
            Map<String, String> paramsMap = bulidParms(request.getSubCreditsMsg().getAuthParams(),erweihuoConfig.getSubCreditsMethod());
            request.getSubCreditsMsg().setAuthParams(paramsMap);
            request.getSubCreditsMsg().setHttpType(SubCreditsMsgDto.HTTP_POST);
            request.setHttpUrl(AssembleTool.assembleUrl(host, paramsMap));
        }catch (Exception e){
            LOGGER.warn("[ErweihuoApi- 构建扣积分参数异常]error:{}", e);
        }
        return request;
    }



    /**
     * 扣积分参数处理
     * @param request
     * @return
     */
    public CreditsMessage getSubCredits(CreditsMessage request) {
        try{
            String url = request.getHttpUrl();
            String host = this.getGateway(url);
            // 取出原始参数/
            Map<String, String> paramsMap = bulidParms(request.getAuthParams(),erweihuoConfig.getSubCreditsMethod());
            request.setAuthParams(paramsMap);
            request.setHttpType(CreditsMessage.HTTP_POST);
            request.setHttpUrl(AssembleTool.assembleUrl(host, paramsMap));
        }catch (Exception e){
            LOGGER.warn("[ErweihuoApi- 构建扣积分参数异常]error:{}", e);
        }
        return request;
    }


    /**
     * 加积分参数处理
     * @param request
     * @return
     */
    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request){
        try{
            String url = request.getHttpUrl();
            String host = this.getGateway(url);
            request.setHttpType(CreditsMessage.HTTP_POST);
            Map<String, String> paramsMap = bulidParms(request.getAuthParams(),erweihuoConfig.getAddCreditsMethod());
            request.setAuthParams(paramsMap);
            request.setHttpUrl(AssembleTool.assembleUrl(host, paramsMap));
        }catch (Exception e){
            LOGGER.warn("[ErweihuoApi- 构建加积分参数异常]error:{}", e);
        }
        return request;
    }




    /**
     * 查询积分参数处理
     * @param request
     * @return
     */
    public CreditsMessageDto getQueryCreditsMessage(CreditsMessageDto request){
        try{
            String url = request.getHttpUrl();
            String host = this.getGateway(url);
            request.setHttpType(CreditsMessage.HTTP_POST);
            Map<String, String> paramsMap = bulidQueryParms(request.getAuthParams(),erweihuoConfig.getQueryCreditsMethod());
            request.setAuthParams(paramsMap);
            request.setHttpUrl(AssembleTool.assembleUrl(host, paramsMap));
        }catch (Exception e){
            LOGGER.warn("[ErweihuoApi- 构建查询积分参数异常]error:{}", e);
        }
        return request;
    }








    /**
     * 解析开发者加 减积分返回数据
     * @param body
     * @return
     */
    public String parseCrditsRsp(String body){
        try{
            String bodyTemp = URLDecoder.decode(body,"utf-8");
            JSONObject jsonObject = JSONObject.parseObject(bodyTemp);
            Map<String, String> map = Maps.newHashMap();
            if ("1".equals(jsonObject.getString("code"))) {
                map.put("status", "ok");
                //对方没有返回业务订单号，但是我们系统又做了重复性校验，所以只能先放个时间戳进去
                map.put("bizId", String.valueOf(new Date().getTime()));
            } else {
                map.put("errorCode",jsonObject.getString("errorCode"));
                map.put("status", "no");
                map.put("errorMessage", jsonObject.getString("message"));
            }
            return JsonTool.objectToJson(map);
        }catch (Exception e){
            LOGGER.info("erweihuo parseCrditsRsp error,boby is {}",body,e);
            return body;
        }
    }



    /**
     * 解析开发者查询积分返回数据
     * @param body
     * @return
     */
    public Object parseQueryCrditsRsp(String body){
        try{
            String bodyTemp = URLDecoder.decode(body,"utf-8");
            JSONObject jsonObject = JSONObject.parseObject(bodyTemp);
            if ("1".equals(jsonObject.getString("code"))) {
                Object data = jsonObject.get("data");
                if(data != null){
                    JSONObject dataJsonObject  = JSONObject.parseObject(JSONObject.toJSONString(data));
                    Object creditsData = dataJsonObject.get("data");
                    if(creditsData != null){
                        JSONObject creditsJsonObject  = JSONObject.parseObject(JSONObject.toJSONString(creditsData));
                        return creditsJsonObject.get("degree");
                    }
                }

                return null;
            } else {
                return null;
            }

        }catch (Exception e){
            LOGGER.info("erweihuo parseQueryCrditsRsp error,boby is {}",body,e);
            return null;
        }
    }









    /**
     * 构造加减积分参数
     *
     * */
    private Map<String,String> bulidParms( Map<String, String> originalParams,String method) throws IOException {
        Map< String, String> form = Maps.newHashMap();
        //通用参数
        form.put("method",method);
        form.put("appKey", erweihuoConfig.getAppKey());
        form.put("v",erweihuoConfig.getVersion());
        form.put("lang", LANGUAGE);
        form.put("timestamp", String.valueOf(System.currentTimeMillis()));
        form.put("env",erweihuoConfig.getEnv());
        //业务参数
        form.put("num",originalParams.get("credits"));
        form.put("customerRegisterId",originalParams.get("uid"));
        form.put("mobile","");
        form.put("countryCode","");
        form.put("shopEntityId",erweihuoConfig.getShopEntityId());
        form.put("entityId",erweihuoConfig.getEntityId());
        form.put("thirdFlowId",originalParams.get("orderNum"));
        form.put("memo",originalParams.get("description") != null ? originalParams.get("description"): "" );
        //对请求参数列表进行签名
        String sign = ErweihuoRopUtils.sign(form, erweihuoConfig.getAppSecret());
        form.put("sign", sign);
        return form;
    }



    /**
     * 构造查询参数
     *
     * */
    private Map<String,String> bulidQueryParms( Map<String, String> originalParams,String method) throws IOException {
        Map< String, String> form = Maps.newHashMap();
        //通用参数
        form.put("method",method);
        form.put("appKey", erweihuoConfig.getAppKey());
        form.put("v",erweihuoConfig.getVersion());
        form.put("lang", LANGUAGE);
        form.put("timestamp", String.valueOf(System.currentTimeMillis()));
        form.put("env",erweihuoConfig.getEnv());
        //业务参数
        form.put("customerRegisterId",originalParams.get("customerRegisterId"));
        form.put("mobile","");
        form.put("countryCode","");
        form.put("entityId",erweihuoConfig.getEntityId());
        //对请求参数列表进行签名
        String sign = ErweihuoRopUtils.sign(form, erweihuoConfig.getAppSecret());
        form.put("sign", sign);
        return form;
    }






    /**
     * 获取接口网关
     *
     * @param url
     * @return java.lang.String
     * @throw
     */
    private String getGateway(String url) {
        if (StringUtils.isNotBlank(url)) {
            int index = url.indexOf(DELIMITER);
            if (index != -1) {
                return url.substring(0, index);
            }
        }
        return url;
    }


}
