package cn.com.duiba.biz.credits;

import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import org.apache.http.client.methods.HttpRequestBase;

/**
 * @Description: 趣头条接口定制
 * @Author: fxr
 * @Date: 2019/4/3
 */
public interface FunHeadlinesApi {

    /**
     * 是否趣头条APP
     *
     * @param appId
     * @return
     */
    Boolean isFunHeadlines(Long appId);

    /**
     * 封装扣积分请求参数
     *
     * @param subCreditsMsgWrapper
     * @return
     */
    SubCreditsMsgWrapper getRequestCredits(SubCreditsMsgWrapper subCreditsMsgWrapper);

    /**
     * 封装加积分请求参数
     *
     * @param request
     * @return
     */
    CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request);

    /**
     * 趣头条-封装虚拟商品接口参数（虚拟商品请求通过加积分实现，虚拟标识符为约定的积分）
     *
     * @param request
     * @return
     */
    SupplierRequest getVirturalRequest(SupplierRequest request);

    /**
     * 解析虚拟商品接口开发者请求响应
     *
     * @param message
     * @param body
     * @return
     */
    String getVirturalResponse(SupplierRequest message, String body);


    /**
     * 解析开发者请求响应
     *
     * @param body
     * @return
     */
    String parseCreditsRsp(String body);

    /**
     * 针对虚拟商品充值，请求参数类没有：请求类型参数，默认使用get请求，趣头条的接口需要post方式请求
     *
     * @param message
     * @param http
     * @return
     */
    HttpRequestBase resetFunHeadlinesVirtualHttpType(SupplierRequest message, HttpRequestBase http);
}
