package cn.com.duiba.biz.credits;

import cn.com.duiba.config.HelloConfig;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.AssembleTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * Created by sunyan on 2019/10/29.
 * 哈啰定制
 */
@Service
public class HelloApi {
    private static Logger log = LoggerFactory.getLogger(HelloApi.class);
    @Autowired
    private HelloConfig helloConfig;

    public SupplierRequest getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String params = url.substring(url.indexOf('?') + 1, url.length());
        // 1.将请求URL的参数转换为MAP
        Map<String, String> crediMap = AssembleTool.getUrlParams(params);
        String keys = crediMap.get("params");
        //如果不是HLHF-开头的，走原逻辑
        if(!keys.startsWith("HLHF-")){
            return request;
        }
        //hlhf替换定制接口
        String host = helloConfig.getHlhfUrl();
        String requestUrl =host+"?"+params;
        log.info("哈啰虚拟商品请求参数, newURL={}", requestUrl);
        request.setHttpUrl(requestUrl);
        return request;
    }
}
