package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.constant.HongQiConfig;
import cn.com.duiba.credits.sdk.CreditNotifyParams;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.enums.redis.RedisKeyEnum;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import org.apache.commons.lang.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * 红旗定制api
 *
 * @Author chenxiangge
 * @Date 2020/12/15
 */
@Service
public class HongQiApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(HongQiApi.class);


    private static final String CHARACTER_ENCODE = "UTF-8";

    @Autowired
    private HongQiConfig hongQiConfig;
    @Autowired
    private AppDAO appDAO;
    @Resource(name = "httpClient")
    // HTTP超时已修复
    private CloseableHttpClient httpClient;

    @Resource(name = "stringRedisTemplate")
    private StringRedisTemplate redisTemplate;

    public Boolean isHongQiAppid(Long appId) {
        return hongQiConfig.isHongQiAppId(appId);
    }

    /**
     * 组装扣积分对象  remote形式发起的扣积分请求
     *
     * @return
     */
    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {

        //更改请求类型

        //解析原有请求接口
        String url = message.getHttpUrl();
        String host = url.substring(0, url.indexOf('?'));
        String params = url.substring(url.indexOf('?') + 1);

        message.getSubCreditsMsg().setHttpType(SubCreditsMsgDto.HTTP_POST);
        message.setHttpUrl(host);

        AppDO appByCache = appDAO.getAppByCache(message.getSubCreditsMsg().getAppId());
        return buildHttpRequest(host, params, appByCache);
    }


    /**
     * 加积分请求参数修改
     *
     * @param request
     * @return
     */
    public HttpRequestBase getAddCreditsMessage(CreditsMessageDto request) {
        //更改请求类型
        request.setHttpType(CreditsMessage.HTTP_POST);

        //解析原有请求接口
        String url = request.getHttpUrl();
        String host = url.substring(0, url.indexOf('?'));
        String params = url.substring(url.indexOf('?') + 1);
        AppDO appByCache = appDAO.getAppByCache(Long.parseLong(request.getAppId()));
        return buildHttpRequest(host, params, appByCache);
    }

    /**
     * 兑换结果通知
     *
     * @param notifyUrl
     * @param record
     * @param param
     * @return
     */
    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record, CreditNotifyParams param) {

        HttpPost request = new HttpPost(notifyUrl);
        AppDO appByCache = appDAO.getAppByCache(record.getAppId());
        //签名

        HashMap map = new HashMap();
        map.put("clientId", hongQiConfig.getClientId());
        map.put("tacticsCode", hongQiConfig.getTacticsCode());
        map.put("success", Boolean.toString(param.isSuccess()));
        map.put("errorMessage", param.getErrorMessage());
        map.put("bizId", param.getBizId());
        map.put("appKey", param.getAppKey());
        map.put("appSecret", appDAO.getAppSecret(appByCache));
//
//        map.put("appKey","3oVCwU5jTFvMZVcRK5XzP1BesMbg");
//        map.put("appSecret","4Q191BeyrnB3fWoXAFntkFmwXn9V");
        map.put("timestamp", String.valueOf(param.getTimestamp().getTime()));
        map.put("uid", record.getPartnerUserId());
        map.put("orderNum", param.getOrderNum());
        map.put("transfer", param.getTransfer());
        String sign = SignTool.sign(map);
        map.remove("appSecret");
        map.put("sign", sign);

        LOGGER.info("hongqi body:{}",JSON.toJSONString(map));
        //放入body
        request.setEntity(new StringEntity(JSON.toJSONString(map), "utf-8"));
        //设置header
        setHttpHeader(request);

        return request;
    }


    private HttpPost buildHttpRequest(String host, String params, AppDO appByCache) {
        //将请求URL的参数转换为MAP
        Map<String, String> paramMap = AssembleTool.getUrlParams(params);

        // 虚拟充值解析积分
        String goodsNum = paramMap.get("params");
        if (StringUtils.isNotBlank(goodsNum) && goodsNum.startsWith(hongQiConfig.getVirtualCreditsGoods())) {
            paramMap.put("credits",goodsNum.replace(hongQiConfig.getVirtualCreditsGoods(),""));
        }

        //新增开发者定制参数
        paramMap.put("clientId", hongQiConfig.getClientId());
        paramMap.put("tacticsCode", hongQiConfig.getTacticsCode());
        paramMap.remove("sign");
        //签名
        paramMap.put("appSecret", appDAO.getAppSecret(appByCache));
//        paramMap.put("appKey","3oVCwU5jTFvMZVcRK5XzP1BesMbg");
//        paramMap.put("appSecret","4Q191BeyrnB3fWoXAFntkFmwXn9V");
        paramMap.put("sign", SignTool.sign(paramMap));
        //移除appSecret
        paramMap.remove("appSecret");

        HttpPost request = new HttpPost(host);
        //放入body
        LOGGER.info("hongqi body:{}",JSON.toJSONString(paramMap));
        request.setEntity(new StringEntity(JSON.toJSONString(paramMap), "utf-8"));
        //设置header
        setHttpHeader(request);
        LOGGER.info("hongqi header:{}",JSON.toJSONString(request.getAllHeaders()));
        return request;
    }

    /**
     * 设置请求头
     *
     * @param http
     */
    public void setHttpHeader(HttpRequestBase http) {
        String redisKey = RedisKeyEnum.K004.toString();
        String token = redisTemplate.opsForValue().get(redisKey);

        if (StringUtils.isBlank(token)) {
            TokenResponData tokenData = getToken();
            if (null != tokenData) {
                token = tokenData.getAccessToken();
                //获取过期时间并设置到redis中（提前100s过期）
                redisTemplate.opsForValue().set(redisKey, tokenData.getAccessToken(), tokenData.getExpiresIn() - 100, TimeUnit.SECONDS);
            }
        }
        http.setHeader("Content-Type", "application/json");
        http.setHeader("charset", "UTF-8");
        http.setHeader("Authorization", token);
    }


    /**
     * 通过对方接口获取token
     *
     * @return
     */
    public TokenResponData getToken() {

        String res = null;
        try {
            Map<String, String> map = new HashMap<>();
            //授权模式：客户端模式
            map.put("grant_type", "client_credentials");
            //api平台创建应用后获取
            map.put("client_id", hongQiConfig.getAuthClientId());
            //api平台创建应用后获取
            map.put("client_secret", hongQiConfig.getAuthSecret());
            String url = hongQiConfig.getAuthServerUrl() + hongQiConfig.getRealms() + "/protocol/openid-connect/token";

            return sendPost(httpClient, url, map);
        } catch (Exception e) {
            LOGGER.warn("红旗token值异常, result={}", res, e);
            return null;
        }
    }

    private static TokenResponData sendPost(HttpClient httpClient, String url, Map<String, String> authParams) {
        HttpPost httpPost = new HttpPost(url);
        List<NameValuePair> pairs = new ArrayList<>(authParams.size());
        for (Map.Entry<String, String> entry : authParams.entrySet()) {
            String value = entry.getValue();
            if (value != null) {
                pairs.add(new BasicNameValuePair(entry.getKey(), value));
            }
        }
        httpPost.setEntity(new UrlEncodedFormEntity(pairs, Charset.forName(CHARACTER_ENCODE)));

        // 执行get请求.
        CloseableHttpResponse response = null;
        try {
            HttpUtils.resetTimeOut(httpPost);
            response = (CloseableHttpResponse) httpClient.execute(httpPost);
            if (response.getStatusLine().getStatusCode() != 200) {
                LOGGER.warn("一汽红旗获取token发送请求失败，url={}", url);
                return null;
            }
            String resp = EntityUtils.toString(response.getEntity(), CHARACTER_ENCODE);
            LOGGER.info("一汽红旗获取token请求返回结果，url={},res:{}", url, resp);
            TokenResponData tokenResponData = JSON.parseObject(resp, TokenResponData.class);
            if (StringUtils.isNotBlank(tokenResponData.getError())) {
                LOGGER.warn("一汽红旗获取token发送请求失败，url={},res:{}", url, resp);
                return null;
            }
            return tokenResponData;
        } catch (Exception e) {
            LOGGER.warn("一汽红旗获取token发送请求失败，url={}", url, e);
        } finally {
            if (response != null) {
                try {
                    response.close();
                } catch (IOException e) {
                    LOGGER.warn("一汽红旗获取token关闭response失败", e);
                }
            }
        }
        return null;
    }

    public static class TokenResponData {

        @JSONField(name = "access_token")
        private String accessToken;

        private String type;

        @JSONField(name = "expires_in")
        private Integer expiresIn;

        private String error;

        @JSONField(name = "error_description")
        private String errorDescription;

        public String getError() {
            return error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getErrorDescription() {
            return errorDescription;
        }

        public void setErrorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
        }

        public String getAccessToken() {
            return accessToken;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Integer getExpiresIn() {
            return expiresIn;
        }

        public void setExpiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
        }
    }

    /**
     * 虚拟充值-走开发者加积分接口
     * @param request
     * @return
     */
    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        LOGGER.info("红旗虚拟充值SupplierRequest:{}",JSON.toJSONString(request));
        //解析原有请求接口
        String url = request.getHttpUrl();
        String host = url.substring(0, url.indexOf('?'));
        String params = url.substring(url.indexOf('?') + 1);
        AppDO appByCache = appDAO.getAppByCache(Long.parseLong(request.getAppId()));
        return buildHttpRequest(host, params, appByCache);
    }

//    public static void main(String[] args) {
//        Map<String, String> map = new HashMap<>();
//        //授权模式：客户端模式
//        map.put("grant_type", "client_credentials");
//        //api平台创建应用后获取
//        map.put("client_id", "faw-open-c6199028-9d12-4872-bcec-0b897ee8f912");
////        map.put("client_id", "");
//        //api平台创建应用后获取
////        map.put("client_secret", "LmvDrlW2O5ufOCJkG6a18QZgd8Gq5QNQ");
//        map.put("client_secret", "");
//        String url = "https://auth.faw.cn/auth/realms/openapi/protocol/openid-connect/token";
//
//        HttpPost httpPost = new HttpPost(url);
//        List<NameValuePair> pairs = new ArrayList<>(map.size());
//        for (Map.Entry<String, String> entry : map.entrySet()) {
//            String value = entry.getValue();
//            if (value != null) {
//                pairs.add(new BasicNameValuePair(entry.getKey(), value));
//            }
//        }
//        httpPost.setEntity(new UrlEncodedFormEntity(pairs, Charset.forName(CHARACTER_ENCODE)));
//        String resp = "";
//
//        RequestConfig defaultRequestConfig = RequestConfig.custom()
//                .setSocketTimeout(2000)
//                .setConnectTimeout(20000)
//                .setConnectionRequestTimeout(2000).build();
//        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager();
//        manager.setMaxTotal(100);//连接池的最大连接数。
//        manager.setDefaultMaxPerRoute(100);//每个Rount(远程)请求最大的连接数。
//        manager.setValidateAfterInactivity(1000 * 60 * 5);//连接空闲多长时间（单位：毫秒）进行检查。
//        CloseableHttpClient build = HttpClients.custom()
//                .disableAutomaticRetries()
//                .setConnectionManager(manager)
//                .setDefaultRequestConfig(defaultRequestConfig).build();
//        CloseableHttpResponse response = null;
//
//        try {
//            response = build.execute(httpPost);
////            if (response.getStatusLine().getStatusCode() != 200) {
////                LOGGER.warn("一汽红旗获取token发送请求失败，url={}", url);
////            }
//            resp = EntityUtils.toString(response.getEntity(), CHARACTER_ENCODE);
//            TokenResponData tokenResponData = JSON.parseObject(resp, TokenResponData.class);
//            if (StringUtils.isNotBlank(tokenResponData.getError())) {
//                LOGGER.warn("一汽红旗获取token发送请求失败，url={},res:{}", url, resp);
//            }
//            System.out.println(JSON.toJSONString(tokenResponData));
//        } catch (Exception e) {
//            LOGGER.warn("一汽红旗获取token发送请求失败，url={}", url, e);
//        } finally {
//            if (response != null) {
//                try {
//                    response.close();
//                } catch (IOException e) {
//                    LOGGER.warn("一汽红旗获取token关闭response失败", e);
//                }
//            }
//        }
//    }

}
