package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.config.MengJieConfig;
import cn.com.duiba.credits.sdk.AssembleTool;
import cn.com.duiba.credits.sdk.CreditConsumeParams;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.JsonTool;


import com.alibaba.fastjson.JSONObject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 梦洁加减积分
 */
@Service
public class MengJieCreditsApi {

    @Autowired
    private MengJieConfig mengJieConfig;

    private static Logger log = LoggerFactory.getLogger(MengJieCreditsApi.class);


    public Boolean isMengJie(Long appId){
        List<Long> appIds= Arrays.stream(mengJieConfig.getAppIds().split(",")).map(s->Long.parseLong(s.trim())).collect(Collectors.toList());
        return appIds.contains(appId);
    }

    public static byte[] encryptMD5(byte[] data) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(data);
        return md5.digest();
    }
    public static String toHexValue(byte[] messageDigest) {
        if (messageDigest == null) {
            return "";
        }
        StringBuilder hexValue = new StringBuilder();
        for (byte aMessageDigest : messageDigest) {
            int val = 0xFF & aMessageDigest;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    /**
     * 获取梦洁扣积分请求参数
     */
    public SubCreditsMsgWrapper getMogujieRequestCredits(SubCreditsMsgWrapper request) {
        try {
            CreditConsumeParams creditConsumeParams= request.getSubCreditsMsg().getCreditConsumeParams();
            String src="baison";
            Map<String,String> map=new HashMap<>();
            map.put("key","baison");
            map.put("timestamp",String.valueOf(System.currentTimeMillis()));
            map.put("api_url","crm/integral/add");
            map.put("source","24");
            map.put("vip_code",creditConsumeParams.getUid());
            map.put("integral","-"+(creditConsumeParams.getCredits()).toString());
            map.put("v","2");
            map.put("shop_code","ZB");
            map.put("relation_code",creditConsumeParams.getOrderNum());
            map.put("remark",creditConsumeParams.getDescription());
            Set<String> sets= map.keySet();
            List<String> keys = new ArrayList<>(sets);
            Collections.sort(keys);
            for(String key:keys){
                //System.out.println(key+map.get(key));
                src=src+key+map.get(key);
            }
            src=src+"123456";
            String sign="";
            try{
                sign = toHexValue(encryptMD5(src.getBytes()));
                sign = toHexValue(encryptMD5(sign.getBytes()));
                sign = toHexValue(encryptMD5(sign.getBytes()));
            }
            catch (Exception e){
                log.error("梦洁扣积分签名加密错误",e);
            }
            map.put("sign",sign);
            String head=mengJieConfig.getMengjieUrlHead()+"app_act=crm/integral/add";
            String url= AssembleTool.assembleUrl(head,map);
            request.setHttpUrl(url);
            request.getSubCreditsMsg().setHttpType(SubCreditsMsgDto.HTTP_GET);
            return request;
        } catch (Exception e) {
            log.error("请求梦洁扣积分接口出错", e);
            return request;
        }
    }

    /**
     * 组装加积分对象 正常加积分
     * @param request
     * @return
     */
    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request) throws BizException {
        try {
            Map<String, String> originAuthParams = request.getAuthParams();
            String src="baison";
            Map<String,String> map=new HashMap<>();
            map.put("key","baison");
            map.put("timestamp",String.valueOf(System.currentTimeMillis()));
            map.put("api_url","crm/integral/add");
            map.put("source","24");
            map.put("vip_code",originAuthParams.get("uid"));
            map.put("integral",originAuthParams.get("credits"));
            map.put("v","2");
            map.put("shop_code","ZB");
            map.put("relation_code",originAuthParams.get("orderNum"));
            map.put("remark",originAuthParams.get("description"));
            Set<String> sets= map.keySet();
            List<String> keys = new ArrayList<>(sets);
            Collections.sort(keys);
            for(String key:keys){
                src=src+key+map.get(key);
            }
            src=src+"123456";
            String sign="";
            try{
                sign = toHexValue(encryptMD5(src.getBytes()));
                sign = toHexValue(encryptMD5(sign.getBytes()));
                sign = toHexValue(encryptMD5(sign.getBytes()));
            }
            catch (Exception e){
                log.error("梦洁加积分签名加密错误",e);
            }
            map.put("sign",sign);
            String head=mengJieConfig.getMengjieUrlHead()+"app_act=crm/integral/add";
            String url= AssembleTool.assembleUrl(head,map);
            request.setHttpUrl(url);
            request.setHttpType(CreditsMessage.HTTP_GET);
            return request;
        } catch (Exception e) {
            log.error("请求梦洁加积分接口出错", e);
            return request;
        }
    }

    /**
     * 解析扣积分请求响应  转换成兑吧格式
     * @param body
     * @return
     */
    public String parseCreditsRsp(String body) {
        JSONObject responseBody;
        try {
            responseBody = JSONObject.parseObject(body);
        } catch (Exception e) {
            log.error("JSON.parseObject:", e);
            return body;
        }
        String status = responseBody.getString("status");
        String message=responseBody.getString("message");
        String successStatus="1"; String successMessage="更新成功";
        Map<String, String> duibaDoc = new HashMap<>();
        if (Objects.equals(status,successStatus)&&Objects.equals(message,successMessage)) {
            duibaDoc.put("status", "ok");
            duibaDoc.put("bizId", "");
        } else {
            duibaDoc.put("status", "fail");
            if (message!= null) {
                duibaDoc.put("errorMessage",message);
            }
        }
        duibaDoc.put("bizId",String.valueOf(System.currentTimeMillis()));

        return JsonTool.objectToJson(duibaDoc);
    }

}

